/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.UnZipStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class UnZipStepExecution
extends SynchronousNonBlockingStepExecution<Object> {
    private static final long serialVersionUID = 1L;
    private transient UnZipStep step;

    protected UnZipStepExecution(@Nonnull UnZipStep step, @Nonnull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Object run() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        if (this.step.isTest()) {
            return this.test();
        }
        FilePath source = ws.child(this.step.getZipFile());
        if (!source.exists()) {
            throw new IOException(source.getRemote() + " does not exist.");
        }
        if (source.isDirectory()) {
            throw new IOException(source.getRemote() + " is a directory.");
        }
        FilePath destination = ws;
        if (!StringUtils.isBlank((String)this.step.getDir())) {
            destination = ws.child(this.step.getDir());
        }
        return source.act((FilePath.FileCallable)new UnZipFileCallable(listener, destination, this.step.getGlob(), this.step.isRead(), this.step.getCharset(), this.step.isQuiet()));
    }

    private Boolean test() throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        FilePath source = ws.child(this.step.getZipFile());
        if (!source.exists()) {
            listener.error(source.getRemote() + " does not exist.");
            return false;
        }
        if (source.isDirectory()) {
            listener.error(source.getRemote() + " is a directory.");
            return false;
        }
        return (Boolean)source.act((FilePath.FileCallable)new TestZipFileCallable(listener));
    }

    static class TestZipFileCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private TaskListener listener;

        public TestZipFileCallable(TaskListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            logger = this.listener.getLogger();
            zip = null;
            try {
                zip = new ZipFile(f);
                logger.print("Checking ");
                logger.print(zip.size());
                logger.print(" zipped entries in ");
                logger.println(f.getAbsolutePath());
                checksum = new CRC32();
                buffer = new byte[4096];
                entries = zip.entries();
lbl12:
                // 6 sources

                while (entries.hasMoreElements()) {
                    block19: {
                        checksum.reset();
                        entry = entries.nextElement();
                        if (entry.isDirectory()) continue;
                        inputStream = zip.getInputStream(entry);
                        var10_11 = null;
                        try {
                            while ((length = IOUtils.read((InputStream)inputStream, (byte[])buffer)) > 0) {
                                checksum.update(buffer, 0, length);
                            }
                            if (checksum.getValue() == entry.getCrc()) ** GOTO lbl66
                            this.listener.error("Checksum error in : " + f.getAbsolutePath() + ":" + entry.getName());
                            var12_15 = false;
                            if (inputStream != null) {
                                if (var10_11 == null) break block19;
                            }
                            ** GOTO lbl64
                        }
                        catch (Throwable var11_14) {
                            try {
                                var10_11 = var11_14;
                                throw var11_14;
                            }
                            catch (Throwable var14_17) {
                                if (inputStream == null) throw var14_17;
                                if (var10_11 == null) {
                                    inputStream.close();
                                    throw var14_17;
                                }
                                try {
                                    inputStream.close();
                                    throw var14_17;
                                }
                                catch (Throwable var15_18) {
                                    var10_11.addSuppressed(var15_18);
                                    throw var14_17;
                                }
                            }
                        }
                        try {
                            inputStream.close();
                        }
                        catch (Throwable var13_16) {
                            var10_11.addSuppressed(var13_16);
                        }
                        ** GOTO lbl64
                    }
                    inputStream.close();
                    ** GOTO lbl64
                }
                ** GOTO lbl77
            }
            catch (ZipException e) {
                block20: {
                    try {
                        this.listener.error("Error validating zip file: " + e.getMessage());
                        var6_7 = false;
                    }
                    catch (Throwable var16_19) {
                        IOUtils.closeQuietly(zip);
                        throw var16_19;
                    }
lbl64:
                    // 4 sources

                    IOUtils.closeQuietly((Closeable)zip);
                    return var12_15;
lbl66:
                    // 1 sources

                    if (inputStream == null) ** GOTO lbl12
                    if (var10_11 == null) break block20;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable var11_13) {
                        var10_11.addSuppressed(var11_13);
                    }
                    ** GOTO lbl12
                }
                inputStream.close();
                ** GOTO lbl12
lbl77:
                // 1 sources

                var8_9 = true;
                IOUtils.closeQuietly((Closeable)zip);
                return var8_9;
                IOUtils.closeQuietly((Closeable)zip);
                return var6_7;
            }
        }
    }

    public static class UnZipFileCallable
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private final TaskListener listener;
        private final FilePath destination;
        private final String glob;
        private final boolean read;
        private final boolean quiet;
        private final String charset;

        public UnZipFileCallable(TaskListener listener, FilePath destination, String glob, boolean read, String charset, boolean quiet) {
            this.listener = listener;
            this.destination = destination;
            this.glob = glob;
            this.read = read;
            this.charset = charset;
            this.quiet = quiet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> invoke(File zipFile, VirtualChannel channel) throws IOException, InterruptedException {
            TreeMap<String, String> treeMap;
            Integer fileCount;
            ZipFile zip;
            PrintStream logger;
            block39: {
                if (!this.read) {
                    this.destination.mkdirs();
                }
                logger = this.listener.getLogger();
                zip = null;
                boolean doGlob = !StringUtils.isBlank((String)this.glob);
                TreeMap<String, String> strMap = new TreeMap<String, String>();
                try {
                    logger.println("Extracting from " + zipFile.getAbsolutePath());
                    Charset charsetForZip = Charset.forName(this.charset);
                    zip = new ZipFile(zipFile, charsetForZip);
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    fileCount = 0;
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (doGlob && !this.matches(entry.getName(), this.glob)) continue;
                        FilePath f = this.destination.child(entry.getName());
                        if (entry.isDirectory()) {
                            if (this.read) continue;
                            f.mkdirs();
                            continue;
                        }
                        Integer n = fileCount;
                        fileCount = fileCount + 1;
                        Serializable serializable = fileCount;
                        if (!this.read) {
                            if (!this.quiet) {
                                logger.print("Extracting: ");
                                logger.print(entry.getName());
                                logger.print(" -> ");
                                logger.println(f.getRemote());
                            }
                            InputStream inputStream = zip.getInputStream(entry);
                            serializable = null;
                            try {
                                OutputStream outputStream = f.write();
                                Throwable throwable = null;
                                try {
                                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                    outputStream.flush();
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (outputStream == null) continue;
                                    if (throwable != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    outputStream.close();
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                serializable = throwable;
                                throw throwable;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (serializable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)serializable).addSuppressed(throwable);
                                    }
                                    continue;
                                }
                                inputStream.close();
                                continue;
                            }
                        }
                        if (!this.quiet) {
                            logger.print("Reading: ");
                            logger.println(entry.getName());
                        }
                        InputStream is = zip.getInputStream(entry);
                        serializable = null;
                        try {
                            strMap.put(entry.getName(), IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset()));
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is == null) continue;
                            if (serializable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    if (!this.read) break block39;
                    logger.print("Read: ");
                    logger.print(fileCount);
                    logger.println(" files");
                    treeMap = strMap;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zip);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)zip);
                return treeMap;
            }
            logger.print("Extracted: ");
            logger.print(fileCount);
            logger.println(" files");
            treeMap = null;
            IOUtils.closeQuietly((Closeable)zip);
            return treeMap;
        }

        boolean matches(String path, String glob) {
            String safeGlob = glob.replace('/', File.separatorChar);
            String safePath = path.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeGlob, (String)safePath);
        }
    }
}

