/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.FileWrapper;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TouchStep
extends Step {
    private final String file;
    private Long timestamp;

    @DataBoundConstructor
    public TouchStep(String file) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("can't be blank", "file");
        }
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    @DataBoundSetter
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(this, context);
    }

    public static class ExecutionImpl
    extends SynchronousNonBlockingStepExecution<FileWrapper> {
        private static final long serialVersionUID = 1L;
        private transient TouchStep step;

        protected ExecutionImpl(@Nonnull TouchStep step, @Nonnull StepContext context) {
            super(context);
            this.step = step;
        }

        protected FileWrapper run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            FilePath file = ws.child(this.step.getFile());
            long timestamp = this.step.getTimestamp() != null ? this.step.getTimestamp() : System.currentTimeMillis();
            file.getParent().mkdirs();
            file.touch(timestamp);
            return new FileWrapper(file);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "touch";
        }

        public String getDisplayName() {
            return "Create a file (if not already exist) in the workspace, and set the timestamp";
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }
    }
}

