/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import hudson.Extension;
import hudson.model.Descriptor;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.ZipStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ZipStep
extends AbstractStepImpl {
    private final String zipFile;
    private String dir;
    private String glob;
    private boolean archive = false;

    @DataBoundConstructor
    public ZipStep(String zipFile) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)zipFile)) {
            throw new Descriptor.FormException("Can not be empty", "zipFile");
        }
        this.zipFile = zipFile;
    }

    public String getZipFile() {
        return this.zipFile;
    }

    public String getDir() {
        return this.dir;
    }

    @DataBoundSetter
    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getGlob() {
        return this.glob;
    }

    @DataBoundSetter
    public void setGlob(String glob) {
        this.glob = glob;
    }

    public boolean isArchive() {
        return this.archive;
    }

    @DataBoundSetter
    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ZipStepExecution.class);
        }

        public String getFunctionName() {
            return "zip";
        }

        public String getDisplayName() {
            return "Create Zip file";
        }
    }
}

