/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.maven;

import hudson.Extension;
import hudson.FilePath;
import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteMavenPomStep
extends AbstractStepImpl {
    private String file;
    private final Model model;

    @DataBoundConstructor
    public WriteMavenPomStep(Model model) {
        this.model = model;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public Model getModel() {
        return this.model;
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient FilePath ws;
        @Inject
        private transient WriteMavenPomStep step;

        protected Void run() throws Exception {
            FilePath path = !StringUtils.isBlank((String)this.step.getFile()) ? this.ws.child(this.step.getFile()) : this.ws.child("pom.xml");
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            new MavenXpp3Writer().write(path.write(), this.step.getModel());
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "writeMavenPom";
        }

        public String getDisplayName() {
            return "Write a maven project file.";
        }
    }
}

