/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.maven;

import hudson.Extension;
import hudson.FilePath;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReadMavenPomStep
extends AbstractStepImpl {
    private static final String ORG_APACHE_MAVEN_MODEL = "org.apache.maven.model";
    private String file;

    @DataBoundConstructor
    public ReadMavenPomStep() {
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    @Extension
    public static class WhiteLister
    extends Whitelist {
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            if (receiver == null) {
                return false;
            }
            Class<?> aClass = receiver.getClass();
            Package aPackage = aClass.getPackage();
            if (aPackage == null) {
                return false;
            }
            String name = aPackage.getName();
            return name.equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL) && (method.getName().startsWith("set") || method.getName().startsWith("get") || method.getName().startsWith("add") || method.getName().startsWith("find"));
        }

        public boolean permitsConstructor(@Nonnull Constructor<?> constructor, @Nonnull Object[] args) {
            if (constructor == null) {
                return false;
            }
            Package aPackage = constructor.getDeclaringClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL);
        }

        public boolean permitsStaticMethod(@Nonnull Method method, @Nonnull Object[] args) {
            return false;
        }

        public boolean permitsFieldGet(@Nonnull Field field, @Nonnull Object receiver) {
            if (receiver == null) {
                return false;
            }
            Package aPackage = receiver.getClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL);
        }

        public boolean permitsFieldSet(@Nonnull Field field, @Nonnull Object receiver, Object value) {
            if (receiver == null) {
                return false;
            }
            Package aPackage = receiver.getClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL);
        }

        public boolean permitsStaticFieldGet(@Nonnull Field field) {
            return false;
        }

        public boolean permitsStaticFieldSet(@Nonnull Field field, Object value) {
            return false;
        }
    }

    @Extension
    public static class PackageAutoImporter
    extends GroovyShellDecorator {
        public void customizeImports(CpsFlowExecution context, ImportCustomizer ic) {
            ic.addStarImports(new String[]{ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL});
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Model> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient FilePath ws;
        @Inject
        private transient ReadMavenPomStep step;

        protected Model run() throws Exception {
            FilePath path = !StringUtils.isBlank((String)this.step.getFile()) ? this.ws.child(this.step.getFile()) : this.ws.child("pom.xml");
            if (!path.exists()) {
                throw new FileNotFoundException(path.getRemote() + " does not exist.");
            }
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            return new MavenXpp3Reader().read(path.read());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "readMavenPom";
        }

        public String getDisplayName() {
            return "Read a maven project file.";
        }
    }
}

