/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.Yaml;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.constructor.SafeConstructor;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.reader.UnicodeReader;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReadYamlStep
extends AbstractStepImpl {
    private String file;
    private String text;

    @DataBoundConstructor
    public ReadYamlStep() {
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public String getText() {
        return this.text;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @Inject
        private transient ReadYamlStep step;

        protected Object run() throws Exception {
            String yamlText = "";
            if (!StringUtils.isBlank((String)this.step.getFile())) {
                FilePath path = this.ws.child(this.step.getFile());
                if (!path.exists()) {
                    throw new FileNotFoundException(path.getRemote() + " does not exist.");
                }
                if (path.isDirectory()) {
                    throw new FileNotFoundException(path.getRemote() + " is a directory.");
                }
                try (UnicodeReader reader = new UnicodeReader(path.read());){
                    yamlText = IOUtils.toString((Reader)reader);
                }
            }
            if (!StringUtils.isBlank((String)this.step.getText())) {
                yamlText = yamlText + System.getProperty("line.separator") + this.step.getText();
            }
            Iterable<Object> yaml = new Yaml(new SafeConstructor()).loadAll(yamlText);
            LinkedList<Object> result = new LinkedList<Object>();
            for (Object data : yaml) {
                result.add(data);
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new ByteArrayOutputStream());){
                out.writeObject(result);
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "readYaml";
        }

        public String getDisplayName() {
            return "Read yaml from files in the workspace or text.";
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            Object text;
            Object file;
            ReadYamlStep step = new ReadYamlStep();
            if (arguments.containsKey("file") && (file = arguments.get("file")) != null) {
                step.setFile(file.toString());
            }
            if (arguments.containsKey("text") && (text = arguments.get("text")) != null) {
                step.setText(text.toString());
            }
            if (StringUtils.isBlank((String)step.getFile()) && StringUtils.isBlank((String)step.getText())) {
                throw new IllegalArgumentException("At least one of file or text needs to be provided to readYaml.");
            }
            return step;
        }
    }
}

