/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.ReadPropertiesStep;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class ReadPropertiesStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FilePath ws;
    @Inject
    private transient ReadPropertiesStep step;

    protected Map<String, Object> run() throws Exception {
        PrintStream logger = this.listener.getLogger();
        Properties properties = new Properties();
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (f.exists() && !f.isDirectory()) {
                properties.load(f.read());
            } else if (f.isDirectory()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" is a directory, omitting from properties gathering");
            } else if (!f.exists()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" does not exist, omitting from properties gathering");
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            StringReader sr = new StringReader(this.step.getText());
            properties.load(sr);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.step.getDefaults() != null) {
            result.putAll(this.step.getDefaults());
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(entry.getKey() != null ? entry.getKey().toString() : null, entry.getValue());
        }
        return result;
    }
}

