/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import hudson.Extension;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.ReadPropertiesStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReadPropertiesStep
extends AbstractStepImpl {
    private String file;
    private String text;
    private Map<String, Object> defaults;

    @DataBoundConstructor
    public ReadPropertiesStep() {
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public String getText() {
        return this.text;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    @DataBoundSetter
    public void setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ReadPropertiesStepExecution.class);
        }

        public String getFunctionName() {
            return "readProperties";
        }

        public String getDisplayName() {
            return "Read properties from files in the workspace or text.";
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            Object defaults;
            Object text;
            Object file;
            ReadPropertiesStep step = new ReadPropertiesStep();
            if (arguments.containsKey("file") && (file = arguments.get("file")) != null) {
                step.setFile(file.toString());
            }
            if (arguments.containsKey("text") && (text = arguments.get("text")) != null) {
                step.setText(text.toString());
            }
            if (arguments.containsKey("defaults") && (defaults = arguments.get("defaults")) != null && defaults instanceof Map) {
                step.setDefaults((Map)defaults);
            }
            if (StringUtils.isBlank((String)step.getFile()) && StringUtils.isBlank((String)step.getText())) {
                throw new IllegalArgumentException("At least one of file or text needs to be provided to readProperties.");
            }
            return step;
        }
    }
}

