/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.multibranch.defaults;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectFactory;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.branch.OrganizationFolder;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.multibranch.defaults.PipelineBranchDefaultsProjectFactory;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PipelineMultiBranchDefaultsProjectFactory
extends MultiBranchProjectFactory.BySCMSourceCriteria {
    public static final String SCRIPT = "Jenkinsfile";
    private String scriptId = "Jenkinsfile";
    private boolean useSandbox = false;

    @DataBoundConstructor
    public PipelineMultiBranchDefaultsProjectFactory() {
    }

    @DataBoundSetter
    public void setScriptId(String scriptId) {
        this.scriptId = StringUtils.isEmpty((String)scriptId) ? SCRIPT : scriptId;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    @DataBoundSetter
    public void setUseSandbox(boolean useSandbox) {
        this.useSandbox = useSandbox;
    }

    public boolean getUseSandbox() {
        return this.useSandbox;
    }

    protected WorkflowMultiBranchProject doCreateProject(ItemGroup<?> parent, String name, Map<String, Object> attributes) {
        WorkflowMultiBranchProject project = new WorkflowMultiBranchProject(parent, name);
        this.configureProjectFactoryFor(project);
        return project;
    }

    public void updateExistingProject(MultiBranchProject<?, ?> project, Map<String, Object> attributes, TaskListener listener) throws IOException, InterruptedException {
        if (project instanceof WorkflowMultiBranchProject) {
            this.configureProjectFactoryFor((WorkflowMultiBranchProject)project);
        }
    }

    protected SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        return new SCMSourceCriteria(){

            public boolean isHead(SCMSourceCriteria.Probe probe, TaskListener listener) throws IOException {
                return true;
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object obj) {
                return this.getClass().isInstance(obj);
            }
        };
    }

    private void configureProjectFactoryFor(WorkflowMultiBranchProject project) {
        PipelineBranchDefaultsProjectFactory projectFactory = new PipelineBranchDefaultsProjectFactory();
        projectFactory.setScriptId(this.scriptId);
        projectFactory.setUseSandbox(this.useSandbox);
        project.setProjectFactory((BranchProjectFactory)projectFactory);
    }

    @Extension
    public static class DescriptorImpl
    extends MultiBranchProjectFactoryDescriptor {
        public MultiBranchProjectFactory newInstance() {
            return null;
        }

        @Nonnull
        public String getDisplayName() {
            return "by default Jenkinsfile";
        }
    }

    @Extension
    public static class PerFolderAdder
    extends TransientActionFactory<OrganizationFolder> {
        public Class<OrganizationFolder> type() {
            return OrganizationFolder.class;
        }

        public Collection<? extends Action> createFor(OrganizationFolder target) {
            if (target.getProjectFactories().get(PipelineMultiBranchDefaultsProjectFactory.class) != null && target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new Snippetizer.LocalAction());
            }
            return Collections.emptySet();
        }
    }
}

