/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.multibranch.defaults;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Queue;
import hudson.model.TaskListener;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.jenkinsci.plugins.pipeline.multibranch.defaults.PipelineMultiBranchDefaultsProject;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

class DefaultsBinder
extends FlowDefinition {
    private String scriptId;
    private boolean useSandbox;

    public DefaultsBinder(String scriptId, boolean useSandbox) {
        this.scriptId = scriptId;
        this.useSandbox = useSandbox;
    }

    public FlowExecution create(FlowExecutionOwner handle, TaskListener listener, List<? extends Action> actions) throws Exception {
        Config config;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("inappropriate context");
        }
        Queue.Executable exec = handle.getExecutable();
        if (!(exec instanceof WorkflowRun)) {
            throw new IllegalStateException("inappropriate context");
        }
        GlobalConfigFiles store = GlobalConfigFiles.get();
        if (store != null && (config = store.getById(this.scriptId)) != null) {
            if (this.useSandbox) {
                listener.getLogger().println("Running with default Jenkinsfile ID: " + this.scriptId + "; within Groovy sandbox.");
            } else {
                listener.getLogger().println("Running with default Jenkinsfile ID: " + this.scriptId);
            }
            return new CpsFlowDefinition(config.content, this.useSandbox).create(handle, listener, actions);
        }
        throw new IllegalArgumentException("Default Jenkinsfile not found. Check configuration.");
    }

    @Extension
    public static class HideMeElsewhere
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return context instanceof WorkflowJob && ((WorkflowJob)context).getParent() instanceof PipelineMultiBranchDefaultsProject;
            }
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        public String getDisplayName() {
            return "Pipeline script from default Jenkinsfile";
        }
    }
}

