/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.githubstatusnotification;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.Proxy;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class GitHubStatusNotificationStep
extends AbstractStepImpl {
    public static final String CREDENTIALS_ID_NOT_EXISTS = "The credentialsId does not seem to exist, please check it";
    public static final String NULL_CREDENTIALS_ID = "Credentials ID is null or empty";
    public static final String CREDENTIALS_LOGIN_INVALID = "The supplied credentials are invalid to login";
    public static final String INVALID_REPO = "The specified repository does not exist for the specified account";
    public static final String INVALID_COMMIT = "The specified commit does not exist in the specified repository";
    private GHCommitState status;
    private String description;
    private String context = "jenkins/githubnotify";
    private String repo;
    private String sha;
    private String gitApiUrl = DescriptorImpl.gitApiUrl;
    private String credentialsId;
    private String account;
    private String targetUrl = DescriptorImpl.targetUrl;

    @DataBoundConstructor
    public GitHubStatusNotificationStep(GHCommitState status, String description) {
        this.status = status;
        this.description = description;
    }

    @DataBoundSetter
    public void setGitApiUrl(String gitApiUrl) {
        this.gitApiUrl = gitApiUrl;
    }

    @DataBoundSetter
    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setStatus(GHCommitState status) {
        this.status = status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @DataBoundSetter
    public void setContext(String context) {
        this.context = context;
    }

    @DataBoundSetter
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @DataBoundSetter
    public void setSha(String sha) {
        this.sha = sha;
    }

    @DataBoundSetter
    public void setAccount(String account) {
        this.account = account;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public GHCommitState getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContext() {
        return this.context;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getSha() {
        return this.sha;
    }

    public String getGitApiUrl() {
        return this.gitApiUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getAccount() {
        return this.account;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    private static <T extends Credentials> T getCredentials(@Nonnull Class<T> type, @Nonnull String credentialsId, Item context) {
        return (T)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(type, (Item)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(type)}));
    }

    @Nonnull
    private static Proxy getProxy(@Nonnull String host) {
        Jenkins jenkins = Jenkins.getActiveInstance();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        return jenkins.proxy.createProxy(host);
    }

    private static GitHub getGitHubIfValid(String credentialsId, String gitApiUrl, Item context) throws IOException {
        if (credentialsId == null || credentialsId.isEmpty()) {
            throw new IllegalArgumentException(NULL_CREDENTIALS_ID);
        }
        UsernamePasswordCredentials credentials = GitHubStatusNotificationStep.getCredentials(UsernamePasswordCredentials.class, credentialsId, context);
        if (credentials == null) {
            throw new IllegalArgumentException(CREDENTIALS_ID_NOT_EXISTS);
        }
        GitHubBuilder githubBuilder = new GitHubBuilder();
        githubBuilder.withOAuthToken(credentials.getPassword().getPlainText(), credentials.getUsername());
        if (gitApiUrl == null || gitApiUrl.isEmpty()) {
            githubBuilder = githubBuilder.withProxy(GitHubStatusNotificationStep.getProxy("https://api.github.com"));
        } else {
            githubBuilder = githubBuilder.withEndpoint(gitApiUrl);
            githubBuilder = githubBuilder.withProxy(GitHubStatusNotificationStep.getProxy(gitApiUrl));
        }
        GitHub github = githubBuilder.build();
        if (github.isCredentialValid()) {
            return github;
        }
        throw new IllegalArgumentException(CREDENTIALS_LOGIN_INVALID);
    }

    private static GHRepository getRepoIfValid(String credentialsId, String gitApiUrl, String account, String repo, Item context) throws IOException {
        GitHub github = GitHubStatusNotificationStep.getGitHubIfValid(credentialsId, gitApiUrl, context);
        GHRepository repository = github.getUser(account).getRepository(repo);
        if (repository == null) {
            throw new IllegalArgumentException(INVALID_REPO);
        }
        return repository;
    }

    private static GHCommit getCommitIfValid(String credentialsId, String gitApiUrl, String account, String repo, String sha, Item context) throws IOException {
        GHRepository repository = GitHubStatusNotificationStep.getRepoIfValid(credentialsId, gitApiUrl, account, repo, context);
        GHCommit commit = repository.getCommit(sha);
        if (commit == null) {
            throw new IllegalArgumentException(INVALID_COMMIT);
        }
        return commit;
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        public static final String UNABLE_TO_INFER_DATA = "Unable to infer git data, please specify repo, credentialsId, account and sha values";
        public static final String UNABLE_TO_INFER_COMMIT = "Could not infer exact commit to use, please specify one";
        public static final String UNABLE_TO_INFER_CREDENTIALS_ID = "Can not infer exact credentialsId to use, please specify one";
        @Inject
        private transient GitHubStatusNotificationStep step;
        @StepContextParameter
        private transient Run run;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            String targetUrl = this.getTargetUrl();
            String credentialsId = this.getCredentialsId();
            String repo = this.getRepo();
            String account = this.getAccount();
            GHRepository repository = GitHubStatusNotificationStep.getRepoIfValid(credentialsId, this.step.getGitApiUrl(), account, repo, (Item)this.run.getParent());
            String sha1 = this.getSha1();
            GHCommit commit = null;
            try {
                commit = repository.getCommit(sha1);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(GitHubStatusNotificationStep.INVALID_COMMIT, ex);
            }
            repository.createCommitStatus(commit.getSHA1(), this.step.getStatus(), targetUrl, this.step.getDescription(), this.step.getContext());
            return null;
        }

        public GitHubStatusNotificationStep getStep() {
            return this.step;
        }

        public void setStep(GitHubStatusNotificationStep step) {
            this.step = step;
        }

        public Run getRun() {
            return this.run;
        }

        public void setRun(Run run) {
            this.run = run;
        }

        private String getTargetUrl() {
            return this.step.getTargetUrl() == null || this.step.getTargetUrl().isEmpty() ? DisplayURLProvider.get().getRunURL(this.run) : this.step.getTargetUrl();
        }

        private String getCredentialsId() {
            if (this.step.getCredentialsId() == null || this.step.getCredentialsId().isEmpty()) {
                return this.tryToInferCredentialsId();
            }
            return this.step.getCredentialsId();
        }

        private String getRepo() {
            if (this.step.getRepo() == null || this.step.getRepo().isEmpty()) {
                return this.tryToInferRepo();
            }
            return this.step.getRepo();
        }

        private String getAccount() {
            if (this.step.getAccount() == null || this.step.getAccount().isEmpty()) {
                return this.tryToInferAccount();
            }
            return this.step.getAccount();
        }

        private String getSha1() {
            if (this.step.getSha() == null || this.step.getSha().isEmpty()) {
                return this.tryToInferSha();
            }
            return this.step.getSha();
        }

        private String tryToInferCredentialsId() {
            String credentialsID = this.getSource().getScanCredentialsId();
            if (credentialsID != null) {
                return credentialsID;
            }
            throw new IllegalArgumentException(UNABLE_TO_INFER_CREDENTIALS_ID);
        }

        private String tryToInferRepo() {
            return this.getSource().getRepository();
        }

        private String tryToInferAccount() {
            return this.getSource().getRepoOwner();
        }

        private String tryToInferSha() {
            SCMRevisionAction action = (SCMRevisionAction)this.run.getAction(SCMRevisionAction.class);
            if (action != null) {
                SCMRevision revision = action.getRevision();
                if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
                    return ((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash();
                }
                if (revision instanceof PullRequestSCMRevision) {
                    return ((PullRequestSCMRevision)revision).getPullHash();
                }
                throw new IllegalArgumentException(UNABLE_TO_INFER_COMMIT);
            }
            throw new IllegalArgumentException(UNABLE_TO_INFER_COMMIT);
        }

        private GitHubSCMSource getSource() {
            ItemGroup parent = this.run.getParent().getParent();
            if (parent instanceof SCMSourceOwner) {
                SCMSourceOwner owner = (SCMSourceOwner)parent;
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return (GitHubSCMSource)source;
                }
                throw new IllegalArgumentException(UNABLE_TO_INFER_DATA);
            }
            throw new IllegalArgumentException(UNABLE_TO_INFER_DATA);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String gitApiUrl = null;
        public static final String targetUrl = null;
        public static final String context = "jenkins/githubnotify";

        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "githubNotify";
        }

        public String getDisplayName() {
            return "Notifies GitHub of the status of a Pull Request";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            StandardListBoxModel result = new StandardListBoxModel();
            List credentialsList = CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM);
            for (UsernamePasswordCredentials credential : credentialsList) {
                result = result.with((IdCredentials)credential);
            }
            return result;
        }

        public ListBoxModel doFillStatusItems() {
            ListBoxModel list = new ListBoxModel();
            for (GHCommitState state : GHCommitState.values()) {
                list.add(state.name(), state.name());
            }
            return list;
        }

        public FormValidation doTestConnection(@QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="gitApiUrl") String gitApiUrl, @AncestorInPath Item context) {
            try {
                GitHubStatusNotificationStep.getGitHubIfValid(credentialsId, gitApiUrl, context);
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckRepo(@QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="repo") String repo, @QueryParameter(value="account") String account, @QueryParameter(value="gitApiUrl") String gitApiUrl, @AncestorInPath Item context) {
            try {
                GitHubStatusNotificationStep.getRepoIfValid(credentialsId, gitApiUrl, account, repo, context);
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckSha(@QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="repo") String repo, @QueryParameter(value="sha") String sha, @QueryParameter(value="account") String account, @QueryParameter(value="gitApiUrl") String gitApiUrl, @AncestorInPath Item context) {
            try {
                GitHubStatusNotificationStep.getCommitIfValid(credentialsId, gitApiUrl, account, repo, sha, context);
                return FormValidation.ok((String)"Commit seems valid");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

