/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.unit;

import net.sf.json.JSONObject;

public class UnitResult {
    private static final String FAILURE = "fail";
    private static final String SKIP = "skip";
    private static final String PASS = "pass";
    private static final String UNSOUND = "unsound";
    private static final String ENGINE_NAME = "Jenkins";
    private final String className;
    private final String name;
    private final String stackTrace;
    private final float duration;
    private final int failCount;
    private final int skipCount;
    private final int passCount;

    public UnitResult(String className, String displayName, String stackTrace, float duration, int failCount, int skipCount, int passCount) {
        this.className = className;
        this.name = displayName;
        this.duration = duration;
        this.failCount = failCount;
        this.skipCount = skipCount;
        this.passCount = passCount;
        this.stackTrace = stackTrace;
    }

    public String getHarbormasterResult() {
        if (this.failCount > 0) {
            return FAILURE;
        }
        if (this.skipCount > 0) {
            return SKIP;
        }
        if (this.passCount > 0) {
            return PASS;
        }
        return UNSOUND;
    }

    public JSONObject toHarbormaster() {
        return new JSONObject().element("name", (Object)this.name).element("result", (Object)this.getHarbormasterResult()).element("namespace", (Object)this.className).element("details", (Object)this.stackTrace).element("engine", (Object)ENGINE_NAME).element("duration", (double)this.duration);
    }
}

