/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.unit;

import com.uber.jenkins.phabricator.unit.UnitResult;
import com.uber.jenkins.phabricator.unit.UnitResults;
import com.uber.jenkins.phabricator.unit.UnitTestProvider;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;

public class JUnitTestProvider
extends UnitTestProvider {
    @Override
    public boolean resultsAvailable() {
        return this.getJUnitResults() != null;
    }

    @Override
    public UnitResults getResults() {
        return this.convertJUnit(this.getJUnitResults());
    }

    public UnitResults convertJUnit(TestResult jUnitResults) {
        UnitResults results = new UnitResults();
        if (jUnitResults == null) {
            return results;
        }
        for (SuiteResult sr : jUnitResults.getSuites()) {
            for (CaseResult cr : sr.getCases()) {
                UnitResult result = new UnitResult(cr.getClassName(), cr.getDisplayName(), cr.getErrorStackTrace(), cr.getDuration(), cr.getFailCount(), cr.getSkipCount(), cr.getPassCount());
                results.add(result);
            }
        }
        return results;
    }

    private TestResult getJUnitResults() {
        Run<?, ?> build = this.getBuild();
        TestResultAction jUnitAction = (TestResultAction)build.getAction(TestResultAction.class);
        if (jUnitAction == null) {
            return null;
        }
        return jUnitAction.getResult();
    }
}

