/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.DifferentialClient;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.utils.Logger;
import java.io.IOException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class SendHarbormasterUriTask
extends Task {
    private final DifferentialClient diffClient;
    private final String phid;
    private final String buildUri;

    public SendHarbormasterUriTask(Logger logger, DifferentialClient diffClient, String phid, String buildUri) {
        super(logger);
        this.diffClient = diffClient;
        this.phid = phid;
        this.buildUri = buildUri;
    }

    @Override
    protected String getTag() {
        return "send-harbormaster-uri";
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void execute() {
        try {
            JSONObject result = this.diffClient.sendHarbormasterUri(this.phid, this.buildUri);
            if (result.containsKey((Object)"error_info") && !(result.get("error_info") instanceof JSONNull)) {
                this.info(String.format("Harbormaster declined URI artifact: %s", result.getString("error_info")));
                this.result = Task.Result.FAILURE;
            } else {
                this.result = Task.Result.SUCCESS;
            }
        }
        catch (ConduitAPIException e) {
            this.printStackTrace(e);
            this.result = Task.Result.FAILURE;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            this.result = Task.Result.FAILURE;
        }
    }

    @Override
    protected void tearDown() {
    }
}

