/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.DifferentialClient;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.utils.Logger;
import java.io.IOException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class PostCommentTask
extends Task {
    private static final boolean SILENT = false;
    private static final String DEFAULT_COMMENT_ACTION = "none";
    private final DifferentialClient differentialClient;
    private final String revisionID;
    private final String comment;
    private final String commentAction;

    public PostCommentTask(Logger logger, DifferentialClient differentialClient, String revisionID, String comment, String commentAction) {
        super(logger);
        this.differentialClient = differentialClient;
        this.revisionID = revisionID;
        this.comment = comment;
        this.commentAction = commentAction;
    }

    @Override
    protected String getTag() {
        return "post-comment";
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void execute() {
        JSONObject postDifferentialCommentResult = this.postDifferentialComment(this.comment, false, this.commentAction);
        if (postDifferentialCommentResult == null || !(postDifferentialCommentResult.get("error_info") instanceof JSONNull)) {
            if (postDifferentialCommentResult != null) {
                this.info(String.format("Got error %s with action %s", postDifferentialCommentResult.get("error_info"), this.commentAction));
            }
            this.info("Re-trying with action 'none'");
            this.postDifferentialComment(this.comment, false, DEFAULT_COMMENT_ACTION);
        }
    }

    @Override
    protected void tearDown() {
    }

    private JSONObject postDifferentialComment(String message, boolean silent, String action) {
        try {
            JSONObject postDifferentialCommentResult = this.differentialClient.postComment(this.revisionID, message, silent, action);
            this.result = Task.Result.SUCCESS;
            return postDifferentialCommentResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ConduitAPIException e) {
            this.info("unable to post comment");
            this.result = Task.Result.FAILURE;
            return null;
        }
    }
}

