/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.uberalls.UberallsClient;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;

public class NonDifferentialBuildTask
extends Task {
    protected final UberallsClient uberallsClient;
    protected final CodeCoverageMetrics codeCoverageMetrics;
    protected final boolean uberallsEnabled;
    protected final String commitSha;

    public NonDifferentialBuildTask(Logger logger, UberallsClient uberallsClient, CodeCoverageMetrics codeCoverageMetrics, boolean uberallsEnabled, String commitSha) {
        super(logger);
        this.uberallsClient = uberallsClient;
        this.codeCoverageMetrics = codeCoverageMetrics;
        this.uberallsEnabled = uberallsEnabled;
        this.commitSha = commitSha;
    }

    @Override
    protected String getTag() {
        return "non-differential";
    }

    @Override
    protected void setup() {
        if (this.codeCoverageMetrics == null) {
            this.info("Coverage result not found. Ignoring build.");
            this.result = Task.Result.IGNORED;
        } else if (!this.uberallsEnabled || CommonUtils.isBlank(this.uberallsClient.getBaseURL())) {
            this.info("Uberalls not configured. Skipping build.");
            this.result = Task.Result.SKIPPED;
        }
    }

    @Override
    protected void execute() {
        if (this.result == Task.Result.UNKNOWN) {
            if (!CommonUtils.isBlank(this.commitSha)) {
                this.info(String.format("Sending coverage result for %s as %s", this.commitSha, this.codeCoverageMetrics.toString()));
                this.result = this.uberallsClient.recordCoverage(this.commitSha, this.codeCoverageMetrics) ? Task.Result.SUCCESS : Task.Result.FAILURE;
            } else {
                this.info("No line coverage found. Ignoring build.");
                this.result = Task.Result.IGNORED;
            }
        }
    }

    @Override
    protected void tearDown() {
    }
}

