/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.provider;

import com.uber.jenkins.phabricator.unit.JUnitTestProvider;
import com.uber.jenkins.phabricator.unit.UnitTestProvider;
import com.uber.jenkins.phabricator.utils.Logger;
import jenkins.model.Jenkins;

public abstract class InstanceProvider<T> {
    private static final String JUNIT_PLUGIN_NAME = "junit";
    private static final String LOGGER_TAG = "plugin-provider";
    private final Jenkins jenkins;
    private final String pluginName;
    private final Logger logger;

    private InstanceProvider(Jenkins jenkins, String pluginName, Logger logger) {
        this.jenkins = jenkins;
        this.pluginName = pluginName;
        this.logger = logger;
    }

    public static UnitTestProvider getUnitTestProvider(Logger logger) {
        return (UnitTestProvider)new InstanceProvider<UnitTestProvider>(Jenkins.getInstance(), JUNIT_PLUGIN_NAME, logger){

            @Override
            protected UnitTestProvider makeInstance() {
                return new JUnitTestProvider();
            }
        }.getInstance();
    }

    final T getInstance() {
        if (this.jenkins.getPlugin(this.pluginName) == null) {
            this.logger.info(LOGGER_TAG, String.format("'%s' plugin not installed.", this.pluginName));
            return null;
        }
        return this.makeInstance();
    }

    abstract T makeInstance();
}

