/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.uber.jenkins.phabricator.credentials.ConduitCredentials;
import com.uber.jenkins.phabricator.credentials.ConduitCredentialsNameProvider;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;

@NameWith(value=ConduitCredentialsNameProvider.class, priority=50)
public class ConduitCredentialsImpl
extends BaseStandardCredentials
implements ConduitCredentials {
    @NonNull
    private final Secret token;
    @Nullable
    private final String gateway;
    @NonNull
    private final String url;

    @DataBoundConstructor
    public ConduitCredentialsImpl(@CheckForNull String id, @NonNull @CheckForNull String url, @Nullable String gateway, @CheckForNull String description, @CheckForNull String token) {
        super(id, description);
        this.url = url;
        this.gateway = gateway;
        this.token = Secret.fromString((String)token);
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public String getGateway() {
        return !CommonUtils.isBlank(this.gateway) ? this.gateway : this.getUrl();
    }

    @Override
    @NonNull
    public String getUrl() {
        return this.url;
    }

    @Extension
    public static class Descriptor
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return "Phabricator Conduit Key";
        }
    }
}

