/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.coverage;

import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class CoverageProvider {
    final Set<String> includeFiles;
    final Map<String, List<Integer>> lineCoverage = new HashMap<String, List<Integer>>();
    CodeCoverageMetrics metrics = null;
    private boolean hasComputedCoverage = false;

    CoverageProvider(Set<String> includeFiles) {
        this.includeFiles = includeFiles;
    }

    public Map<String, List<Integer>> getLineCoverage() {
        this.computeCoverageIfNeeded();
        return this.lineCoverage;
    }

    public boolean hasCoverage() {
        this.computeCoverageIfNeeded();
        return this.metrics != null && this.metrics.getLinesCovered() > 0.0f;
    }

    CodeCoverageMetrics getCoverageMetrics() {
        this.computeCoverageIfNeeded();
        return this.metrics;
    }

    public void computeCoverageIfNeeded() {
        if (!this.hasComputedCoverage) {
            this.computeCoverage();
            this.hasComputedCoverage = true;
        }
    }

    protected abstract void computeCoverage();

    @Nullable
    static String getRelativePathFromProjectRoot(Set<String> includeFiles, String coverageFile) {
        if (includeFiles == null || includeFiles.isEmpty()) {
            return coverageFile;
        }
        int maxMatch = 0;
        String maxMatchFile = null;
        for (String includedFile : includeFiles) {
            int currmatch = CoverageProvider.suffixMatch(includedFile, coverageFile);
            if (currmatch <= maxMatch) continue;
            maxMatch = currmatch;
            maxMatchFile = includedFile;
        }
        return maxMatchFile;
    }

    private static int suffixMatch(String changedFile, String coverageFile) {
        int rIndex;
        int changedFileSize = changedFile.length();
        int coverageFileSize = coverageFile.length();
        if (coverageFileSize > changedFileSize) {
            return 0;
        }
        for (rIndex = 1; coverageFileSize > rIndex && coverageFile.charAt(coverageFileSize - rIndex) == changedFile.charAt(changedFileSize - rIndex); ++rIndex) {
        }
        if (changedFileSize == rIndex) {
            return rIndex;
        }
        if (changedFileSize > rIndex && changedFile.charAt(changedFileSize - rIndex - 1) != '/') {
            return 0;
        }
        return rIndex;
    }

    @Nullable
    public CodeCoverageMetrics getMetrics() {
        if (!this.hasCoverage()) {
            return null;
        }
        return this.getCoverageMetrics();
    }
}

