/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.coverage;

import java.util.Objects;

public class CodeCoverageMetrics {
    private final float packagesCoveragePercent;
    private final float filesCoveragePercent;
    private final float classesCoveragePercent;
    private final float methodCoveragePercent;
    private final float lineCoveragePercent;
    private final float conditionalCoveragePercent;
    private final long linesCovered;
    private final long linesTested;

    public CodeCoverageMetrics(float packagesCoveragePercent, float filesCoveragePercent, float classesCoveragePercent, float methodCoveragePercent, float lineCoveragePercent, float conditionalCoveragePercent, long linesCovered, long linesTested) {
        this.packagesCoveragePercent = packagesCoveragePercent;
        this.filesCoveragePercent = filesCoveragePercent;
        this.classesCoveragePercent = classesCoveragePercent;
        this.methodCoveragePercent = methodCoveragePercent;
        this.lineCoveragePercent = lineCoveragePercent;
        this.conditionalCoveragePercent = conditionalCoveragePercent;
        this.linesCovered = linesCovered;
        this.linesTested = linesTested;
    }

    public float getPackageCoveragePercent() {
        return this.packagesCoveragePercent;
    }

    public float getFilesCoveragePercent() {
        return this.filesCoveragePercent;
    }

    public float getClassesCoveragePercent() {
        return this.classesCoveragePercent;
    }

    public float getMethodCoveragePercent() {
        return this.methodCoveragePercent;
    }

    public float getLineCoveragePercent() {
        return this.lineCoveragePercent;
    }

    public float getConditionalCoveragePercent() {
        return this.conditionalCoveragePercent;
    }

    public float getLinesCovered() {
        return this.linesCovered;
    }

    public float getLinesTested() {
        return this.linesTested;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("package coverage = ");
        sb.append(this.packagesCoveragePercent);
        sb.append(", files coverage = ");
        sb.append(this.filesCoveragePercent);
        sb.append(", classes coverage = ");
        sb.append(this.classesCoveragePercent);
        sb.append(", method coverage = ");
        sb.append(this.methodCoveragePercent);
        sb.append(", line coverage = ");
        sb.append(this.lineCoveragePercent);
        sb.append(", conditional coverage = ");
        sb.append(this.conditionalCoveragePercent);
        sb.append(", lines covered = ");
        sb.append(this.linesCovered);
        sb.append(", linesTested = ");
        sb.append(this.linesTested);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeCoverageMetrics metrics = (CodeCoverageMetrics)o;
        return Float.compare(metrics.packagesCoveragePercent, this.packagesCoveragePercent) == 0 && Float.compare(metrics.filesCoveragePercent, this.filesCoveragePercent) == 0 && Float.compare(metrics.classesCoveragePercent, this.classesCoveragePercent) == 0 && Float.compare(metrics.methodCoveragePercent, this.methodCoveragePercent) == 0 && Float.compare(metrics.lineCoveragePercent, this.lineCoveragePercent) == 0 && Float.compare(metrics.conditionalCoveragePercent, this.conditionalCoveragePercent) == 0 && this.linesCovered == metrics.linesCovered && this.linesTested == metrics.linesTested;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.packagesCoveragePercent), Float.valueOf(this.filesCoveragePercent), Float.valueOf(this.classesCoveragePercent), Float.valueOf(this.methodCoveragePercent), Float.valueOf(this.lineCoveragePercent), Float.valueOf(this.conditionalCoveragePercent), this.linesCovered, this.linesTested);
    }
}

