/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.coverage;

import com.google.common.annotations.VisibleForTesting;
import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.coverage.XmlCoverageProvider;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import java.io.File;
import java.util.Set;

public class CoberturaPluginCoverageProvider
extends XmlCoverageProvider {
    private final CoberturaBuildAction buildAction;

    public CoberturaPluginCoverageProvider(Set<File> coverageReports, Set<String> includeFiles, CoberturaBuildAction buildAction) {
        super(coverageReports, includeFiles);
        this.buildAction = buildAction;
    }

    @Override
    protected void computeMetrics() {
        CoverageResult coverageResult = this.buildAction.getResult();
        this.metrics = CoberturaPluginCoverageProvider.convertCobertura(coverageResult);
    }

    @VisibleForTesting
    static CodeCoverageMetrics convertCobertura(CoverageResult result) {
        if (result == null) {
            return null;
        }
        float packagesCoverage = CoberturaPluginCoverageProvider.getCoveragePercentage(result, CoverageMetric.PACKAGES);
        float filesCoverage = CoberturaPluginCoverageProvider.getCoveragePercentage(result, CoverageMetric.FILES);
        float classesCoverage = CoberturaPluginCoverageProvider.getCoveragePercentage(result, CoverageMetric.CLASSES);
        float methodCoverage = CoberturaPluginCoverageProvider.getCoveragePercentage(result, CoverageMetric.METHOD);
        float lineCoverage = CoberturaPluginCoverageProvider.getCoveragePercentage(result, CoverageMetric.LINE);
        float conditionalCoverage = CoberturaPluginCoverageProvider.getCoveragePercentage(result, CoverageMetric.CONDITIONAL);
        long linesCovered = (long)CoberturaPluginCoverageProvider.getCoverageRatio((CoverageResult)result, (CoverageMetric)CoverageMetric.LINE).numerator;
        long linesTested = (long)CoberturaPluginCoverageProvider.getCoverageRatio((CoverageResult)result, (CoverageMetric)CoverageMetric.LINE).denominator;
        return new CodeCoverageMetrics(packagesCoverage, filesCoverage, classesCoverage, methodCoverage, lineCoverage, conditionalCoverage, linesCovered, linesTested);
    }

    private static Ratio getCoverageRatio(CoverageResult result, CoverageMetric metric) {
        Ratio ratio = result.getCoverage(metric);
        if (ratio == null) {
            return Ratio.create((float)0.0f, (float)0.0f);
        }
        return ratio;
    }

    private static float getCoveragePercentage(CoverageResult result, CoverageMetric metric) {
        Ratio ratio = result.getCoverage(metric);
        if (ratio == null) {
            return 0.0f;
        }
        return ratio.getPercentageFloat();
    }
}

