/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.conduit;

import com.uber.jenkins.phabricator.conduit.ConduitAPIClient;
import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.HarbormasterClient;
import com.uber.jenkins.phabricator.lint.LintResults;
import com.uber.jenkins.phabricator.unit.UnitResults;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class DifferentialClient {
    private final String diffID;
    private final ConduitAPIClient conduit;

    public DifferentialClient(String diffID, ConduitAPIClient conduit) {
        this.diffID = diffID;
        this.conduit = conduit;
    }

    public JSONObject postComment(String revisionID, String message, boolean silent, String action) throws IOException, ConduitAPIException {
        JSONObject params = new JSONObject();
        params.element("revision_id", (Object)revisionID).element("action", (Object)action).element("message", (Object)message).element("silent", silent);
        return this.callConduit("differential.createcomment", params);
    }

    public JSONObject fetchDiff() throws IOException, ConduitAPIException {
        JSONObject response;
        JSONObject params = new JSONObject().element("ids", (Object)new String[]{this.diffID});
        JSONObject query = this.callConduit("differential.querydiffs", params);
        try {
            response = query.getJSONObject("result");
        }
        catch (JSONException e) {
            throw new ConduitAPIException(String.format("No 'result' object found in conduit call: (%s) %s", e.getMessage(), query.toString(2)));
        }
        try {
            return response.getJSONObject(this.diffID);
        }
        catch (JSONException e) {
            throw new ConduitAPIException(String.format("Unable to find '%s' key in 'result': (%s) %s", this.diffID, e.getMessage(), response.toString(2)));
        }
    }

    public JSONObject sendHarbormasterMessage(String phid, HarbormasterClient.MessageType messageType, UnitResults unitResults, Map<String, String> coverage, LintResults lintResults) throws ConduitAPIException, IOException {
        return new HarbormasterClient(this.conduit).sendHarbormasterMessage(phid, messageType, unitResults, coverage, lintResults);
    }

    public JSONObject sendHarbormasterUri(String phid, String buildUri) throws ConduitAPIException, IOException {
        return new HarbormasterClient(this.conduit).sendHarbormasterUri(phid, buildUri);
    }

    public JSONObject postComment(String revisionID, String message) throws ConduitAPIException, IOException {
        return this.postComment(revisionID, message, true, "none");
    }

    public String getCommitMessage(String revisionID) throws ConduitAPIException, IOException {
        if (revisionID == null) {
            return "";
        }
        JSONObject params = new JSONObject().element("revision_id", (Object)revisionID);
        JSONObject query = this.callConduit("differential.getcommitmessage", params);
        return query.getString("result");
    }

    protected JSONObject callConduit(String methodName, JSONObject params) throws ConduitAPIException, IOException {
        return this.conduit.perform(methodName, params);
    }
}

