/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.conduit;

import com.uber.jenkins.phabricator.PhabricatorPostbuildAction;
import com.uber.jenkins.phabricator.PhabricatorPostbuildSummaryAction;
import hudson.model.Action;
import hudson.model.Run;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class Differential {
    private static final String UNKNOWN_AUTHOR = "unknown";
    private static final String UNKNOWN_EMAIL = "unknown";
    private final JSONObject rawJSON;
    private String commitMessage;

    public Differential(JSONObject rawJSON) {
        this.rawJSON = rawJSON;
    }

    public String getDiffID() {
        String rawDiffId = (String)this.rawJSON.get("id");
        if (rawDiffId == null || rawDiffId.equals("")) {
            return null;
        }
        return rawDiffId;
    }

    public String getRevisionID(boolean formatted) {
        String rawRevisionId;
        Object rawRevisionIdObj = this.rawJSON.get("revisionID");
        String string = rawRevisionId = rawRevisionIdObj != null && !(rawRevisionIdObj instanceof JSONNull) ? (String)rawRevisionIdObj : null;
        if (rawRevisionId == null || rawRevisionId.equals("")) {
            return null;
        }
        if (formatted) {
            return String.format("D%s", rawRevisionId);
        }
        return rawRevisionId;
    }

    public String getPhabricatorLink(String phabricatorURL) {
        String revisionID = this.getRevisionID(true);
        try {
            URL base = new URL(phabricatorURL);
            return new URL(base, revisionID).toString();
        }
        catch (MalformedURLException e) {
            return String.format("%s%s", phabricatorURL, revisionID);
        }
    }

    public void decorate(Run<?, ?> build, String phabricatorURL) {
        build.addAction((Action)PhabricatorPostbuildAction.createShortText(this.getRevisionID(true), this.getPhabricatorLink(phabricatorURL)));
        PhabricatorPostbuildSummaryAction summary = this.createSummary(phabricatorURL);
        build.addAction((Action)summary);
    }

    public PhabricatorPostbuildSummaryAction createSummary(String phabricatorURL) {
        return new PhabricatorPostbuildSummaryAction("phabricator.png", this.getPhabricatorLink(phabricatorURL), this.getDiffID(), this.getRevisionID(true), this.getAuthorName(), this.getAuthorEmail(), this.getCommitMessage());
    }

    private String getAuthorName() {
        return this.getOrElse(this.rawJSON, "authorName", "unknown");
    }

    public String getAuthorEmail() {
        return this.getOrElse(this.rawJSON, "authorEmail", "unknown");
    }

    private String getOrElse(JSONObject json, String key, String orElse) {
        if (json.has(key)) {
            return json.getString(key);
        }
        return orElse;
    }

    public String getBaseCommit() {
        return (String)this.rawJSON.get("sourceControlBaseRevision");
    }

    public String getBranch() {
        Object branchName = this.rawJSON.get("branch");
        if (branchName instanceof JSONNull) {
            return "(none)";
        }
        try {
            return (String)branchName;
        }
        catch (ClassCastException e) {
            return "(unknown)";
        }
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMesasge) {
        this.commitMessage = commitMesasge;
    }

    public Set<String> getChangedFiles() {
        HashSet<String> changedFiles = new HashSet<String>();
        JSONArray changes = this.rawJSON.getJSONArray("changes");
        for (int i = 0; i < changes.size(); ++i) {
            JSONObject change = changes.getJSONObject(i);
            String file = (String)change.get("currentPath");
            if (file == null) continue;
            changedFiles.add(file);
        }
        return changedFiles;
    }
}

