/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.conduit;

import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class ConduitAPIClient {
    private static final String API_TOKEN_KEY = "token";
    private static final String CONDUIT_METADATA_KEY = "__conduit__";
    private final String conduitURL;
    private final String conduitToken;

    public ConduitAPIClient(String conduitURL, String conduitToken) {
        this.conduitURL = conduitURL;
        this.conduitToken = conduitToken;
    }

    public JSONObject perform(String action, JSONObject params) throws IOException, ConduitAPIException {
        CloseableHttpResponse response;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpUriRequest request = this.createRequest(action, params);
        try {
            response = client.execute(request);
        }
        catch (ClientProtocolException e) {
            throw new ConduitAPIException(e.getMessage());
        }
        InputStream responseBody = response.getEntity().getContent();
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new ConduitAPIException(IOUtils.toString((InputStream)responseBody, (Charset)Charset.defaultCharset()), response.getStatusLine().getStatusCode());
        }
        JsonSlurper jsonParser = new JsonSlurper();
        return (JSONObject)jsonParser.parse(responseBody);
    }

    public HttpUriRequest createRequest(String action, JSONObject params) throws UnsupportedEncodingException, ConduitAPIException {
        HttpPost post;
        try {
            post = new HttpPost(new URL(new URL(new URL(this.conduitURL), "/api/"), action).toURI());
        }
        catch (MalformedURLException e) {
            throw new ConduitAPIException(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new ConduitAPIException(e.getMessage());
        }
        JSONObject conduitParams = new JSONObject();
        conduitParams.put(API_TOKEN_KEY, (Object)this.conduitToken);
        params.put(CONDUIT_METADATA_KEY, (Object)conduitParams);
        ArrayList<BasicNameValuePair> formData = new ArrayList<BasicNameValuePair>();
        formData.add(new BasicNameValuePair("params", params.toString()));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formData, "UTF-8");
        post.setEntity((HttpEntity)entity);
        return post;
    }
}

