/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class RemoteFileFetcher {
    private static final int DEFAULT_MAX_SIZE = 1000;
    private static final String LOGGER_TAG = "file-fetcher";
    private final FilePath workspace;
    private final Logger logger;
    private final String fileName;
    private final String maxSize;

    public RemoteFileFetcher(FilePath workspace, Logger logger, String fileName, String maxSize) {
        this.workspace = workspace;
        this.logger = logger;
        this.fileName = fileName;
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteFile() throws InterruptedException, IOException {
        if (CommonUtils.isBlank(this.fileName)) {
            this.logger.info(LOGGER_TAG, "no file configured");
            return null;
        }
        FilePath[] src = this.workspace.list(this.fileName);
        if (src.length == 0) {
            this.logger.info(LOGGER_TAG, "no files found by path: '" + this.fileName + "'");
            return null;
        }
        if (src.length > 1) {
            this.logger.info(LOGGER_TAG, "Found multiple matches. Reading first only.");
        }
        FilePath source = src[0];
        int maxLength = 1000;
        if (!CommonUtils.isBlank(this.maxSize)) {
            maxLength = Integer.parseInt(this.maxSize, 10);
        }
        if (source.length() < (long)maxLength) {
            maxLength = (int)source.length();
        }
        byte[] buffer = new byte[maxLength];
        InputStream stream = source.read();
        try {
            IOUtils.read((InputStream)stream, (byte[])buffer);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new String(buffer);
    }
}

