/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.uber.jenkins.phabricator.ConduitCredentialsDescriptor;
import com.uber.jenkins.phabricator.PhabricatorNotifier;
import com.uber.jenkins.phabricator.credentials.ConduitCredentials;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class PhabricatorNotifierDescriptor
extends BuildStepDescriptor<Publisher> {
    private String credentialsID;
    private String uberallsURL;
    private boolean isBlueOceanEnabled;

    public PhabricatorNotifierDescriptor() {
        super(PhabricatorNotifier.class);
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "Post to Phabricator";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData.getJSONObject("uberalls"));
        this.save();
        return super.configure(req, formData);
    }

    public ListBoxModel doFillCredentialsIDItems(@AncestorInPath Jenkins context, @QueryParameter String remoteBase) {
        return ConduitCredentialsDescriptor.doFillCredentialsIDItems(context);
    }

    public ConduitCredentials getCredentials(Job owner) {
        return ConduitCredentialsDescriptor.getCredentials(owner, this.credentialsID);
    }

    public String getCredentialsID() {
        return this.credentialsID;
    }

    public void setCredentialsID(String credentialsID) {
        this.credentialsID = credentialsID;
    }

    public String getUberallsURL() {
        if (!CommonUtils.isBlank(this.uberallsURL)) {
            return this.uberallsURL;
        }
        return null;
    }

    public void setUberallsURL(String value) {
        this.uberallsURL = value;
    }

    public boolean getIsBlueOceanEnabled() {
        return this.isBlueOceanEnabled;
    }

    public void setIsBlueOceanEnabled(boolean value) {
        this.isBlueOceanEnabled = value;
    }
}

