/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.uber.jenkins.phabricator.BuildResultProcessor;
import com.uber.jenkins.phabricator.CoverageCheckSettings;
import com.uber.jenkins.phabricator.PhabricatorCauseOfInterruption;
import com.uber.jenkins.phabricator.PhabricatorNotifierDescriptor;
import com.uber.jenkins.phabricator.PhabricatorPostbuildAction;
import com.uber.jenkins.phabricator.conduit.ConduitAPIClient;
import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.Differential;
import com.uber.jenkins.phabricator.conduit.DifferentialClient;
import com.uber.jenkins.phabricator.coverage.CoberturaPluginCoverageProvider;
import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.coverage.CoverageProvider;
import com.uber.jenkins.phabricator.coverage.JacocoPluginCoverageProvider;
import com.uber.jenkins.phabricator.coverage.XmlCoverageProvider;
import com.uber.jenkins.phabricator.credentials.ConduitCredentials;
import com.uber.jenkins.phabricator.provider.InstanceProvider;
import com.uber.jenkins.phabricator.tasks.NonDifferentialBuildTask;
import com.uber.jenkins.phabricator.tasks.NonDifferentialHarbormasterTask;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.uberalls.UberallsClient;
import com.uber.jenkins.phabricator.unit.UnitTestProvider;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class PhabricatorNotifier
extends Notifier
implements SimpleBuildStep {
    private static final String DEFAULT_XML_COVERAGE_REPORT_PATTERN = "**/coverage*.xml, **/cobertura*.xml, **/jacoco*.xml";
    private static final CoverageReportFilenameFilter COVERAGE_FILENAME_FILTER = new CoverageReportFilenameFilter();
    private static final String ABORT_TAG = "abort";
    private static final String UBERALLS_TAG = "uberalls";
    private static final String COVERAGE_TAG = "coverage";
    private static final String CONDUIT_TAG = "conduit";
    private static final String PHABRICATOR_COVERAGE = "phabricator-coverage";
    private final boolean commentOnSuccess;
    private final boolean uberallsEnabled;
    private final CoverageCheckSettings coverageCheckSettings;
    private final boolean commentWithConsoleLinkOnFailure;
    private final boolean preserveFormatting;
    private final String commentFile;
    private final String commentSize;
    private final boolean customComment;
    private final boolean processLint;
    private final String lintFile;
    private final String lintFileSize;
    private final String coverageReportPattern;
    private final boolean sendPartialResults;
    private transient UberallsClient uberallsClient;

    @DataBoundConstructor
    public PhabricatorNotifier(boolean commentOnSuccess, boolean uberallsEnabled, boolean coverageCheck, double coverageThreshold, double minCoverageThreshold, String coverageReportPattern, boolean preserveFormatting, String commentFile, String commentSize, boolean commentWithConsoleLinkOnFailure, boolean customComment, boolean processLint, String lintFile, String lintFileSize, boolean sendPartialResults) {
        this.commentOnSuccess = commentOnSuccess;
        this.uberallsEnabled = uberallsEnabled;
        this.coverageCheckSettings = new CoverageCheckSettings(coverageCheck, coverageThreshold, minCoverageThreshold);
        this.commentFile = commentFile;
        this.commentSize = commentSize;
        this.lintFile = lintFile;
        this.lintFileSize = lintFileSize;
        this.preserveFormatting = preserveFormatting;
        this.commentWithConsoleLinkOnFailure = commentWithConsoleLinkOnFailure;
        this.customComment = customComment;
        this.processLint = processLint;
        this.coverageReportPattern = coverageReportPattern;
        this.sendPartialResults = sendPartialResults;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public final void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean passBuildOnUberalls;
        Differential diff;
        ConduitAPIClient conduitClient;
        CoverageProvider coverageProvider;
        EnvVars environment = build.getEnvironment(listener);
        Logger logger = new Logger(listener.getLogger());
        String branch = (String)environment.get((Object)"GIT_BRANCH");
        String gitUrl = (String)environment.get((Object)"GIT_URL");
        if (gitUrl == null) {
            gitUrl = (String)environment.get((Object)"GIT_URL_1");
        }
        UberallsClient uberallsClient = this.getUberallsClient(logger, gitUrl, branch);
        boolean needsDecoration = build.getActions(PhabricatorPostbuildAction.class).size() == 0;
        String diffID = (String)environment.get((Object)"DIFF_ID");
        String phid = (String)environment.get((Object)"PHID");
        boolean isDifferential = !CommonUtils.isBlank(diffID);
        InterruptedBuildAction action = (InterruptedBuildAction)build.getAction(InterruptedBuildAction.class);
        if (action != null) {
            List causes = action.getCauses();
            for (CauseOfInterruption cause : causes) {
                if (!(cause instanceof PhabricatorCauseOfInterruption)) continue;
                logger.warn(ABORT_TAG, "Skipping notification step since this build was interrupted by a newer build with the same differential revision");
                return;
            }
        }
        if (CommonUtils.isBlank(phid) && !isDifferential) {
            if (needsDecoration) {
                build.addAction((Action)PhabricatorPostbuildAction.createShortText(branch, null));
            }
            coverageProvider = this.getCoverageProvider(build, workspace, listener, Collections.emptySet());
            CodeCoverageMetrics coverageResult = null;
            if (coverageProvider != null) {
                coverageResult = coverageProvider.getMetrics();
            }
            NonDifferentialBuildTask nonDifferentialBuildTask = new NonDifferentialBuildTask(logger, uberallsClient, coverageResult, this.uberallsEnabled, (String)environment.get((Object)"GIT_COMMIT"));
            nonDifferentialBuildTask.run();
            return;
        }
        try {
            conduitClient = this.getConduitClient(build.getParent());
        }
        catch (ConduitAPIException e) {
            e.printStackTrace(logger.getStream());
            logger.warn(CONDUIT_TAG, e.getMessage());
            throw new AbortException();
        }
        String whichBuildUrl = this.getDescriptor().getIsBlueOceanEnabled() ? (String)environment.get((Object)"RUN_DISPLAY_URL") : (String)environment.get((Object)"BUILD_URL");
        String buildUrl = whichBuildUrl;
        if (!isDifferential) {
            Result buildResult = build.getResult() == null ? Result.SUCCESS : build.getResult();
            Task.Result result = new NonDifferentialHarbormasterTask(logger, phid, conduitClient, buildResult, buildUrl, this.sendPartialResults).run();
            if (result == Task.Result.SUCCESS) {
                return;
            }
            throw new AbortException();
        }
        DifferentialClient diffClient = new DifferentialClient(diffID, conduitClient);
        try {
            diff = new Differential(diffClient.fetchDiff());
        }
        catch (ConduitAPIException e) {
            e.printStackTrace(logger.getStream());
            logger.warn(CONDUIT_TAG, "Unable to fetch differential from Conduit API");
            logger.warn(CONDUIT_TAG, e.getMessage());
            return;
        }
        if (needsDecoration) {
            diff.decorate(build, this.getPhabricatorURL(build.getParent()));
        }
        Set<String> includeFiles = diff.getChangedFiles();
        coverageProvider = this.getCoverageProvider(build, workspace, listener, includeFiles);
        CodeCoverageMetrics coverageResult = null;
        if (coverageProvider != null) {
            coverageResult = coverageProvider.getMetrics();
        }
        BuildResultProcessor resultProcessor = new BuildResultProcessor(logger, build, workspace, diff, diffClient, (String)environment.get((Object)"PHID"), coverageResult, buildUrl, this.preserveFormatting, this.coverageCheckSettings);
        if (this.uberallsEnabled && !(passBuildOnUberalls = resultProcessor.processParentCoverage(uberallsClient))) {
            build.setResult(Result.FAILURE);
        }
        resultProcessor.processBuildResult(this.commentOnSuccess, this.commentWithConsoleLinkOnFailure);
        resultProcessor.processUnitResults(this.getUnitProvider(build, listener));
        resultProcessor.processCoverage(coverageProvider);
        if (this.processLint) {
            resultProcessor.processLintResults(this.lintFile, this.lintFileSize);
        }
        if (!resultProcessor.processHarbormaster(this.sendPartialResults)) {
            throw new AbortException();
        }
        resultProcessor.processRemoteComment(this.commentFile, this.commentSize);
        resultProcessor.sendComment(this.commentWithConsoleLinkOnFailure);
    }

    protected UberallsClient getUberallsClient(Logger logger, String gitUrl, String branch) {
        if (this.uberallsClient != null) {
            return this.uberallsClient;
        }
        this.setUberallsClient(new UberallsClient(this.getDescriptor().getUberallsURL(), logger, gitUrl, branch));
        return this.uberallsClient;
    }

    protected void setUberallsClient(UberallsClient client) {
        this.uberallsClient = client;
    }

    private ConduitAPIClient getConduitClient(Job owner) throws ConduitAPIException {
        ConduitCredentials credentials = this.getConduitCredentials(owner);
        if (credentials == null) {
            throw new ConduitAPIException("No credentials configured for conduit");
        }
        return new ConduitAPIClient(credentials.getGateway(), credentials.getToken().getPlainText());
    }

    private CoverageProvider getCoverageProvider(Run<?, ?> build, FilePath workspace, TaskListener listener, Set<String> includeFiles) {
        JacocoBuildAction jacocoBuildAction;
        CoberturaBuildAction coberturaBuildAction;
        Result buildResult = build.getResult() == null ? Result.SUCCESS : build.getResult();
        if (!buildResult.isBetterOrEqualTo(Result.UNSTABLE)) {
            return null;
        }
        this.copyCoverageToJenkinsMaster(build, workspace, listener);
        CoverageProvider coverageProvider = null;
        Logger logger = new Logger(listener.getLogger());
        if (Jenkins.getInstance().getPlugin("cobertura") != null && (coberturaBuildAction = (CoberturaBuildAction)build.getAction(CoberturaBuildAction.class)) != null) {
            logger.info(UBERALLS_TAG, "Using coverage metrics from Cobertura Jenkins Plugin");
            coverageProvider = new CoberturaPluginCoverageProvider(this.getCoverageReports(build), includeFiles, coberturaBuildAction);
        }
        if (coverageProvider == null && Jenkins.getInstance().getPlugin("jacoco") != null && (jacocoBuildAction = (JacocoBuildAction)build.getAction(JacocoBuildAction.class)) != null) {
            logger.info(UBERALLS_TAG, "Using coverage metrics from Jacoco Jenkins Plugin");
            coverageProvider = new JacocoPluginCoverageProvider(this.getCoverageReports(build), includeFiles, jacocoBuildAction);
        }
        if (coverageProvider == null) {
            logger.info(UBERALLS_TAG, "Trying to obtain coverage metrics by parsing coverage xml files");
            coverageProvider = new XmlCoverageProvider(this.getCoverageReports(build), includeFiles);
        }
        coverageProvider.computeCoverageIfNeeded();
        this.cleanupCoverageFilesOnJenkinsMaster(build);
        if (coverageProvider.hasCoverage()) {
            return coverageProvider;
        }
        logger.info(UBERALLS_TAG, "No coverage results found");
        return null;
    }

    private void copyCoverageToJenkinsMaster(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        String finalCoverageReportPattern;
        Logger logger = new Logger(listener.getLogger());
        File buildDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildDir);
        String string = finalCoverageReportPattern = this.coverageReportPattern != null ? this.coverageReportPattern : DEFAULT_XML_COVERAGE_REPORT_PATTERN;
        if (workspace != null) {
            try {
                int i = 0;
                for (FilePath report : workspace.list(finalCoverageReportPattern)) {
                    FilePath targetPath = new FilePath(buildTarget, PHABRICATOR_COVERAGE + (i == 0 ? "" : Integer.valueOf(i)) + ".xml");
                    report.copyTo(targetPath);
                    ++i;
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                logger.warn(COVERAGE_TAG, "Unable to copy coverage to " + buildTarget);
            }
        }
    }

    private void cleanupCoverageFilesOnJenkinsMaster(Run<?, ?> build) {
        for (File report : this.getCoverageReports(build)) {
            report.delete();
        }
    }

    private Set<File> getCoverageReports(Run<?, ?> build) {
        HashSet<File> reports = new HashSet<File>();
        File[] foundReports = build.getRootDir().listFiles(COVERAGE_FILENAME_FILTER);
        if (foundReports != null) {
            Collections.addAll(reports, foundReports);
        }
        return reports;
    }

    private UnitTestProvider getUnitProvider(Run<?, ?> build, TaskListener listener) {
        Logger logger = new Logger(listener.getLogger());
        UnitTestProvider unitProvider = InstanceProvider.getUnitTestProvider(logger);
        if (unitProvider == null) {
            return null;
        }
        unitProvider.setBuild(build);
        return unitProvider;
    }

    public boolean isCommentOnSuccess() {
        return this.commentOnSuccess;
    }

    public boolean isCustomComment() {
        return this.customComment;
    }

    public boolean isUberallsEnabled() {
        return this.uberallsEnabled;
    }

    public boolean isCoverageCheck() {
        return this.coverageCheckSettings.isCoverageCheckEnabled();
    }

    public boolean isCommentWithConsoleLinkOnFailure() {
        return this.commentWithConsoleLinkOnFailure;
    }

    public String getCommentFile() {
        return this.commentFile;
    }

    public String getCommentSize() {
        return this.commentSize;
    }

    public double getCoverageThreshold() {
        return this.coverageCheckSettings.getMaxCoverageDecreaseInPercent();
    }

    public double getMinCoverageThreshold() {
        return this.coverageCheckSettings.getMinCoverageInPercent();
    }

    public String getCoverageReportPattern() {
        return this.coverageReportPattern;
    }

    public boolean isPreserveFormatting() {
        return this.preserveFormatting;
    }

    public boolean isProcessLint() {
        return this.processLint;
    }

    public String getLintFile() {
        return this.lintFile;
    }

    public String getLintFileSize() {
        return this.lintFileSize;
    }

    public boolean isSendPartialResults() {
        return this.sendPartialResults;
    }

    private ConduitCredentials getConduitCredentials(Job owner) {
        return this.getDescriptor().getCredentials(owner);
    }

    private String getPhabricatorURL(Job owner) {
        ConduitCredentials credentials = this.getDescriptor().getCredentials(owner);
        if (credentials != null) {
            return credentials.getUrl();
        }
        return null;
    }

    public PhabricatorNotifierDescriptor getDescriptor() {
        return (PhabricatorNotifierDescriptor)super.getDescriptor();
    }

    private static class CoverageReportFilenameFilter
    implements FilenameFilter {
        private CoverageReportFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(PhabricatorNotifier.PHABRICATOR_COVERAGE) && name.endsWith("xml");
        }
    }
}

