/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.uber.jenkins.phabricator.credentials.ConduitCredentials;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;

public class ConduitCredentialsDescriptor {
    private static List<ConduitCredentials> availableCredentials(Job owner) {
        return CredentialsProvider.lookupCredentials(ConduitCredentials.class, (Item)owner, null, new ArrayList());
    }

    public static ConduitCredentials getCredentials(Job owner, String credentialsID) {
        List<ConduitCredentials> available = ConduitCredentialsDescriptor.availableCredentials(owner);
        if (available.size() == 0) {
            return null;
        }
        CredentialsMatcher matcher = credentialsID != null ? CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsID)}) : CredentialsMatchers.always();
        return (ConduitCredentials)CredentialsMatchers.firstOrDefault(available, (CredentialsMatcher)matcher, (Credentials)available.get(0));
    }

    public static ListBoxModel doFillCredentialsIDItems(@AncestorInPath Jenkins context) {
        if (context == null || !context.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        ArrayList domainRequirements = new ArrayList();
        return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(ConduitCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, domainRequirements));
    }
}

