/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports;

import hudson.plugins.performance.data.HttpSample;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.kohsuke.stapler.Stapler;

public abstract class AbstractReport {
    public static final double ZERO_PERCENT = 0.0;
    public static final double ONE_HUNDRED_PERCENT = 100.0;
    public static final double NINETY_PERCENT = 90.0;
    public static final double FIFTY_PERCENT = 50.0;
    protected final ThreadLocal<DecimalFormat> percentFormat;
    protected final ThreadLocal<DecimalFormat> dataFormat;
    protected boolean excludeResponseTime;

    public abstract int countErrors();

    public abstract double errorPercent();

    public AbstractReport() {
        final Locale useThisLocale = Stapler.getCurrentRequest() != null ? Stapler.getCurrentRequest().getLocale() : Locale.getDefault();
        this.percentFormat = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(useThisLocale));
            }
        };
        this.dataFormat = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(useThisLocale));
            }
        };
    }

    public String errorPercentFormated() {
        Stapler.getCurrentRequest().getLocale();
        return this.percentFormat.get().format(this.errorPercent());
    }

    public abstract long getAverage();

    public String getAverageFormated() {
        return this.dataFormat.get().format(this.getAverage());
    }

    public abstract long getMedian();

    public String getMeanFormated() {
        return this.dataFormat.get().format(this.getMedian());
    }

    public abstract long get90Line();

    public String get90LineFormated() {
        return this.dataFormat.get().format(this.get90Line());
    }

    public abstract long getMax();

    public String getMaxFormated() {
        return this.dataFormat.get().format(this.getMax());
    }

    public abstract long getMin();

    public abstract int samplesCount();

    public abstract String getHttpCode();

    public abstract long getAverageDiff();

    public abstract long getMedianDiff();

    public abstract long get90LineDiff();

    public abstract double getErrorPercentDiff();

    public abstract String getLastBuildHttpCodeIfChanged();

    public abstract int getSamplesCountDiff();

    public boolean isExcludeResponseTime() {
        return this.excludeResponseTime;
    }

    public void setExcludeResponseTime(boolean excludeResponseTime) {
        this.excludeResponseTime = excludeResponseTime;
    }

    protected boolean isIncludeResponseTime(HttpSample sample) {
        return !sample.isFailed() || !this.excludeResponseTime || sample.isSummarizer();
    }
}

