/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class IagoParser
extends AbstractParser {
    private static final String STATS_DATE_FORMAT = "yyyymmdd-HH:mm:ss.SSS";

    public IagoParser(String glob, String percentiles) {
        this(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public IagoParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "parrot-server-stats.log";
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = this.createPerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setReportFileName(reportFile.getName());
        try (FileReader fr = new FileReader(reportFile);
             BufferedReader reader = new BufferedReader(fr);){
            String line = reader.readLine();
            while (line != null) {
                HttpSample sample = this.getSample(line, reportFile.getName());
                String nextLine = reader.readLine();
                if (sample != null) {
                    report.addSample(sample);
                }
                line = nextLine;
            }
        }
        return report;
    }

    protected HttpSample getSample(String line, String key) throws ParseException, IllegalArgumentException {
        HttpSample sample = new HttpSample();
        Pattern pattern = Pattern.compile("^INF \\[(.+)\\] stats: (\\{.+\\})$");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            throw new ParseException("Invalid line " + line, 0);
        }
        String dateString = matcher.group(1);
        String statsString = matcher.group(2);
        SimpleDateFormat dateFormat = new SimpleDateFormat(STATS_DATE_FORMAT);
        Date dateObject = dateFormat.parse(dateString);
        GsonBuilder gsonBuilder = new GsonBuilder();
        StatsDeserializer deserializer = new StatsDeserializer();
        gsonBuilder.registerTypeAdapter(Stats.class, (Object)deserializer);
        Gson gson = gsonBuilder.create();
        Stats statsObject = null;
        try {
            statsObject = (Stats)gson.fromJson(statsString, Stats.class);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Invalid stat data " + statsString + ":" + e.getLocalizedMessage());
        }
        sample.setDate(dateObject);
        sample.setSummarizer(true);
        sample.setSummarizerSamples(statsObject.getClientRequests());
        sample.setDuration(statsObject.getClientRequestLatencyMsAverage());
        sample.setSuccessful(true);
        sample.setSummarizerMin(statsObject.getClientRequestLatencyMsMinimum());
        sample.setSummarizerMax(statsObject.getClientRequestLatencyMsMaximum());
        sample.setSummarizerErrors(statsObject.getClientRequests() - statsObject.getClientSuccess() + statsObject.getSumValidationErrors());
        sample.setUri(key);
        return sample;
    }

    private static class StatsDeserializer
    implements JsonDeserializer<Stats> {
        private static final String[] requiredFields = new String[]{"client/request_latency_ms_minimum", "client/request_latency_ms_maximum", "client/request_latency_ms_average", "client/sent_bytes", "client/requests", "client/success"};

        private StatsDeserializer() {
        }

        public Stats deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonObject = (JsonObject)json;
            for (String fieldName : requiredFields) {
                if (jsonObject.get(fieldName) != null) continue;
                throw new JsonParseException("Required Field Not Found: " + fieldName);
            }
            return (Stats)new Gson().fromJson(json, Stats.class);
        }
    }

    protected static class Stats {
        @SerializedName(value="client/request_latency_ms_minimum")
        private long clientRequestLatencyMsMinimum = 0L;
        @SerializedName(value="client/request_latency_ms_maximum")
        private long clientRequestLatencyMsMaximum = 0L;
        @SerializedName(value="client/request_latency_ms_average")
        private long clientRequestLatencyMsAverage = 0L;
        @SerializedName(value="client/sent_bytes")
        private long clientSendBytes = 0L;
        @SerializedName(value="client/requests")
        private long clientRequests = 0L;
        @SerializedName(value="client/success")
        private long clientSuccess = 0L;
        private Map<String, Long> validationErrors = new HashMap<String, Long>();

        public long getClientRequestLatencyMsMinimum() {
            return this.clientRequestLatencyMsMinimum;
        }

        public void setClientRequestLatencyMsMinimum(long clientRequestLatencyMsMinimum) {
            this.clientRequestLatencyMsMinimum = clientRequestLatencyMsMinimum;
        }

        public long getClientRequestLatencyMsMaximum() {
            return this.clientRequestLatencyMsMaximum;
        }

        public void setClientRequestLatencyMsMaximum(long clientRequestLatencyMsMaximum) {
            this.clientRequestLatencyMsMaximum = clientRequestLatencyMsMaximum;
        }

        public long getClientRequestLatencyMsAverage() {
            return this.clientRequestLatencyMsAverage;
        }

        public void setClientRequestLatencyMsAverage(long clientRequestLatencyMsAverage) {
            this.clientRequestLatencyMsAverage = clientRequestLatencyMsAverage;
        }

        public long getClientSendBytes() {
            return this.clientSendBytes;
        }

        public void setClientSendBytes(long clientSendBytes) {
            this.clientSendBytes = clientSendBytes;
        }

        public long getClientRequests() {
            return this.clientRequests;
        }

        public void setClientRequests(long clientRequests) {
            this.clientRequests = clientRequests;
        }

        public long getClientSuccess() {
            return this.clientSuccess;
        }

        public void setClientSuccess(long clientSuccess) {
            this.clientSuccess = clientSuccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValidationError(String name, long value) {
            Map<String, Long> map = this.validationErrors;
            synchronized (map) {
                this.validationErrors.put(name, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSumValidationErrors() {
            long sumValidationErrors = 0L;
            Map<String, Long> map = this.validationErrors;
            synchronized (map) {
                for (Long value : this.validationErrors.values()) {
                    sumValidationErrors += value.longValue();
                }
            }
            return sumValidationErrors;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "Iago";
        }
    }
}

