/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractParser
extends PerformanceReportParser {
    private static final Logger LOGGER = Logger.getLogger(JMeterParser.class.getName());
    private static final String SERIALIZED_DATA_FILE_SUFFIX = ".serialized";
    private static final Cache<String, PerformanceReport> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).softValues().build();
    protected boolean isNumberDateFormat = false;
    protected transient SimpleDateFormat format;
    protected static final String[] DATE_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss,SSS", "yyyy/mm/dd HH:mm:ss"};
    protected String percentiles;

    public AbstractParser(String glob, String percentiles) {
        super(glob);
        this.percentiles = percentiles;
    }

    @Override
    public Collection<PerformanceReport> parse(Run<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        for (File reportFile : reports) {
            PerformanceReport deserializedReport = AbstractParser.loadSerializedReport(reportFile);
            if (deserializedReport != null) {
                result.add(deserializedReport);
                continue;
            }
            try {
                listener.getLogger().println("Performance: Parsing JMeter report file '" + reportFile + "'.");
                PerformanceReport report = this.parse(reportFile);
                result.add(report);
                AbstractParser.saveSerializedReport(reportFile, report);
            }
            catch (Throwable e) {
                listener.getLogger().println("Performance: Failed to parse file '" + reportFile + "': " + e.getMessage());
                e.printStackTrace(listener.getLogger());
            }
        }
        return result;
    }

    abstract PerformanceReport parse(File var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static PerformanceReport loadSerializedReport(File reportFile) {
        if (reportFile == null) {
            throw new NullPointerException("Argument 'reportFile' cannot be null.");
        }
        String serialized = reportFile.getPath() + SERIALIZED_DATA_FILE_SUFFIX;
        ObjectInputStream in = null;
        Cache<String, PerformanceReport> cache = CACHE;
        synchronized (cache) {
            try {
                PerformanceReport report = (PerformanceReport)CACHE.getIfPresent((Object)serialized);
                if (report == null) {
                    in = new ObjectInputStreamWithClassMapping(new BufferedInputStream(new FileInputStream(serialized)));
                    report = (PerformanceReport)in.readObject();
                    CACHE.put((Object)serialized, (Object)report);
                }
                PerformanceReport performanceReport = report;
                return performanceReport;
            }
            catch (FileNotFoundException report) {
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Reading serialized PerformanceReport instance from file '" + serialized + "' failed.", ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Unable to close inputstream after attempt to read data from file '" + serialized + "'.", ex);
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveSerializedReport(File reportFile, PerformanceReport report) {
        if (reportFile == null) {
            throw new NullPointerException("Argument 'reportFile' cannot be null.");
        }
        if (report == null) {
            throw new NullPointerException("Argument 'report' cannot be null.");
        }
        String serialized = reportFile.getPath() + SERIALIZED_DATA_FILE_SUFFIX;
        Cache<String, PerformanceReport> cache = CACHE;
        synchronized (cache) {
            CACHE.put((Object)serialized, (Object)report);
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serialized)));
            out.writeObject(report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Saving serialized PerformanceReport instance to file '" + serialized + "' failed.", ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Unable to close outputstream after attempt to write data to file '" + serialized + "'.", ex);
                }
            }
        }
    }

    public void clearDateFormat() {
        this.format = null;
        this.isNumberDateFormat = false;
    }

    public Date parseTimestamp(String timestamp) {
        if (this.format == null) {
            this.initDateFormat(timestamp);
        }
        try {
            return this.isNumberDateFormat ? new Date(Long.valueOf(timestamp)) : this.format.parse(timestamp);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse timestamp: " + timestamp + ". Please, use one of supported formats: " + Arrays.toString(DATE_FORMATS), e);
        }
    }

    private void initDateFormat(String timestamp) {
        Date result = null;
        for (String format : DATE_FORMATS) {
            try {
                this.format = new SimpleDateFormat(format);
                result = this.format.parse(timestamp);
            }
            catch (ParseException ex) {
                this.format = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            try {
                Long.valueOf(timestamp);
                this.isNumberDateFormat = true;
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Cannot parse timestamp: " + timestamp + ". Please, use one of supported formats: " + Arrays.toString(DATE_FORMATS), ex);
            }
        }
    }

    public static class ObjectInputStreamWithClassMapping
    extends ObjectInputStream {
        protected Hashtable<String, Class> classMapping = new Hashtable();

        public ObjectInputStreamWithClassMapping(InputStream in) throws IOException {
            super(in);
            this.classMapping.put("hudson.plugins.performance.PerformanceReport", PerformanceReport.class);
            this.classMapping.put("hudson.plugins.performance.UriReport", UriReport.class);
            this.classMapping.put("hudson.plugins.performance.UriReport$Sample", UriReport.Sample.class);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return this.classMapping.containsKey(desc.getName()) ? this.classMapping.get(desc.getName()) : super.resolveClass(desc);
        }
    }
}

