/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.plugins.performance.parsers.IagoParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.JUnitParser;
import hudson.plugins.performance.parsers.JmeterSummarizerParser;
import hudson.plugins.performance.parsers.ParserDetector;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.parsers.TaurusParser;
import hudson.plugins.performance.parsers.WrkSummarizerParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

public class ParserFactory {
    protected static final Map<String, String> defaultGlobPatterns = new Hashtable<String, String>();

    public static PerformanceReportParser getParser(Run<?, ?> build, FilePath workspace, PrintStream logger, String glob, EnvVars env) throws IOException, InterruptedException {
        File report;
        if (defaultGlobPatterns.containsKey(glob)) {
            return ParserFactory.getParser(defaultGlobPatterns.get(glob), glob);
        }
        String expandGlob = env.expand(glob);
        try {
            FilePath[] pathList;
            for (FilePath src : pathList = workspace.list(expandGlob)) {
                File localReport = new File(build.getRootDir(), "/temp/" + src.getName());
                if (!src.isDirectory()) {
                    src.copyTo(new FilePath(localReport));
                    return ParserFactory.getParser(ParserDetector.detect(localReport.getPath()), glob);
                }
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
            }
        }
        catch (IOException pathList) {
            // empty catch block
        }
        if (!(report = new File(workspace.getRemote() + '/' + glob)).exists()) {
            FilePath localReport = new FilePath(new File(build.getRootDir(), "/temp/" + glob));
            localReport.copyFrom(new FilePath(workspace, glob));
            return ParserFactory.getParser(ParserDetector.detect(localReport.getRemote()), glob);
        }
        return ParserFactory.getParser(ParserDetector.detect(workspace.getRemote() + '/' + glob), workspace.getRemote() + '/' + glob);
    }

    private static PerformanceReportParser getParser(String parserName, String glob) {
        if (parserName.equals(JMeterParser.class.getSimpleName())) {
            return new JMeterParser(glob);
        }
        if (parserName.equals(JMeterCsvParser.class.getSimpleName())) {
            return new JMeterCsvParser(glob);
        }
        if (parserName.equals(JUnitParser.class.getSimpleName())) {
            return new JUnitParser(glob);
        }
        if (parserName.equals(TaurusParser.class.getSimpleName())) {
            return new TaurusParser(glob);
        }
        if (parserName.equals(WrkSummarizerParser.class.getSimpleName())) {
            return new WrkSummarizerParser(glob);
        }
        if (parserName.equals(JmeterSummarizerParser.class.getSimpleName())) {
            return new JmeterSummarizerParser(glob);
        }
        if (parserName.equals(IagoParser.class.getSimpleName())) {
            return new IagoParser(glob);
        }
        throw new IllegalArgumentException("Unknown parser type: " + parserName);
    }

    static {
        defaultGlobPatterns.put("parrot-server-stats.log", IagoParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.csv", JMeterCsvParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.jtl", JMeterParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.log", JmeterSummarizerParser.class.getSimpleName());
        defaultGlobPatterns.put("**/TEST-*.xml", JUnitParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.xml", TaurusParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.wrk", WrkSummarizerParser.class.getSimpleName());
    }
}

