/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;

public class JMeterCsvParser
extends AbstractParser {
    public static final String COMMAS_NOT_INSIDE_QUOTES = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    public String delimiter;
    public int timestampIdx = -1;
    public int elapsedIdx = -1;
    public int responseCodeIdx = -1;
    public int successIdx = -1;
    public int urlIdx = -1;
    public String pattern;
    private boolean isNumberDateFormat = false;
    private SimpleDateFormat dateFormat;
    protected static final String[] DATE_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSS"};

    @DataBoundConstructor
    public JMeterCsvParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        this.dateFormat = null;
        this.isNumberDateFormat = false;
        PerformanceReport report = new PerformanceReport();
        report.setReportFileName(reportFile.getName());
        BufferedReader reader = new BufferedReader(new FileReader(reportFile));
        try {
            String line = reader.readLine();
            if (line != null) {
                this.readCSVHeader(line);
                line = reader.readLine();
            }
            while (line != null) {
                HttpSample sample = this.getSample(line);
                if (sample != null) {
                    try {
                        report.addSample(sample);
                    }
                    catch (SAXException e) {
                        throw new RuntimeException("Error parsing file '" + reportFile + "': Unable to add sample for line " + line, e);
                    }
                }
                line = reader.readLine();
            }
            PerformanceReport performanceReport = report;
            return performanceReport;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected void readCSVHeader(String line) throws Exception {
        this.delimiter = JMeterCsvParser.lookingForDelimiter(line);
        this.pattern = line;
        String[] fields = this.pattern.split(this.delimiter);
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if ("timestamp".equalsIgnoreCase(field)) {
                this.timestampIdx = i;
                continue;
            }
            if ("elapsed".equalsIgnoreCase(field)) {
                this.elapsedIdx = i;
                continue;
            }
            if ("responseCode".equalsIgnoreCase(field)) {
                this.responseCodeIdx = i;
                continue;
            }
            if ("success".equalsIgnoreCase(field)) {
                this.successIdx = i;
                continue;
            }
            if ("URL".equalsIgnoreCase(field) && this.urlIdx < 0) {
                this.urlIdx = i;
                continue;
            }
            if (!"label".equalsIgnoreCase(field) || this.urlIdx >= 0) continue;
            this.urlIdx = i;
        }
        if (this.timestampIdx < 0 || this.elapsedIdx < 0 || this.responseCodeIdx < 0 || this.successIdx < 0 || this.urlIdx < 0) {
            throw new Exception("Missing required column");
        }
    }

    protected static String lookingForDelimiter(String line) throws Exception {
        for (char ch : line.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return String.valueOf(ch);
        }
        throw new Exception("Cannot find delimiter in header " + line);
    }

    private HttpSample getSample(String line) {
        HttpSample sample = new HttpSample();
        String[] values = line.split(COMMAS_NOT_INSIDE_QUOTES);
        sample.setDate(this.parseTimestamp(values[this.timestampIdx]));
        sample.setDuration(Long.valueOf(values[this.elapsedIdx]));
        sample.setHttpCode(values[this.responseCodeIdx]);
        sample.setSuccessful(Boolean.valueOf(values[this.successIdx]));
        sample.setUri(values[this.urlIdx]);
        return sample;
    }

    private Date parseTimestamp(String timestamp) {
        if (this.dateFormat == null) {
            this.initDateFormat(timestamp);
        }
        try {
            return this.isNumberDateFormat ? new Date(Long.valueOf(timestamp)) : this.dateFormat.parse(timestamp);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse timestamp: " + timestamp + ". Please, use one of supported formats: " + Arrays.toString(DATE_FORMATS), e);
        }
    }

    private void initDateFormat(String timestamp) {
        Date result = null;
        for (String format : DATE_FORMATS) {
            try {
                this.dateFormat = new SimpleDateFormat(format);
                result = this.dateFormat.parse(timestamp);
            }
            catch (ParseException ex) {
                this.dateFormat = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            try {
                Long.valueOf(timestamp);
                this.isNumberDateFormat = true;
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Cannot parse timestamp: " + timestamp + ". Please, use one of supported formats: " + Arrays.toString(DATE_FORMATS), ex);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeterCSV";
        }
    }
}

