/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.details;

import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.plugins.performance.data.ReportValueSelector;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TestSuiteReportDetail
implements ModelObject {
    private final Job<?, ?> project;
    private final String filename;
    private final PerformanceProjectAction.Range buildsLimits;
    private transient List<String> performanceReportTestCaseList;

    public TestSuiteReportDetail(Job<?, ?> project, String filename, PerformanceProjectAction.Range buildsLimits) {
        this.project = project;
        this.filename = filename;
        this.buildsLimits = buildsLimits;
    }

    public void doRespondingTimeGraphPerTestCaseMode(StaplerRequest request, StaplerResponse response) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        final String testUri = request.getParameter("performanceReportTest");
        new Graph(-1L, 600, 200){

            protected JFreeChart createGraph() {
                return TestSuiteReportDetail.createRespondingTimeChart(TestSuiteReportDetail.this.getChartDatasetBuilderForBuilds(testUri, (List<? extends Run<?, ?>>)TestSuiteReportDetail.this.getProject().getBuilds()).build());
            }
        }.doPng(request, response);
    }

    DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getChartDatasetBuilderForBuilds(String testUri, List<? extends Run<?, ?>> builds) {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        ReportValueSelector valueSelector = ReportValueSelector.get(this.getProject());
        int nbBuildsToAnalyze = builds.size();
        for (Run<?, ?> build : builds) {
            if (this.buildsLimits.in(nbBuildsToAnalyze)) {
                if (!this.buildsLimits.includedByStep(build.number)) continue;
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(this.filename);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                String testStaplerUri = PerformanceReport.asStaplerURI(testUri);
                UriReport reportForTestUri = performanceReport.getUriReportMap().get(testStaplerUri);
                if (reportForTestUri != null) {
                    dataSetBuilder.add((Number)valueSelector.getValue(reportForTestUri), (Comparable)((Object)testUri), (Comparable)label);
                }
            }
            --nbBuildsToAnalyze;
        }
        return dataSetBuilder;
    }

    protected static JFreeChart createRespondingTimeChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)Messages.ProjectAction_RespondingTime(), null, (String)"ms", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public List<String> getPerformanceReportTestCaseList() {
        this.performanceReportTestCaseList = new ArrayList<String>(0);
        String performanceReportNameFile = this.getFilename();
        RunList builds = this.getProject().getBuilds();
        for (Run build : builds) {
            PerformanceReport performanceReport;
            PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
            if (performanceBuildAction == null || (performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile)) == null) continue;
            for (UriReport currentReport : performanceReport.getUriReportMap().values()) {
                if (this.performanceReportTestCaseList.contains(currentReport.getUri())) continue;
                this.performanceReportTestCaseList.add(currentReport.getUri());
            }
        }
        Collections.sort(this.performanceReportTestCaseList);
        return this.performanceReportTestCaseList;
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDisplayName() {
        return Messages.TestSuiteReportDetail_DisplayName();
    }
}

