/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.TrendReportGraphs;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.plugins.performance.data.PerformanceReportPosition;
import hudson.plugins.performance.data.ReportValueSelector;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.ThroughputReport;
import hudson.plugins.performance.reports.UriReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.RunList;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PerformanceReportMap
implements ModelObject {
    private transient PerformanceBuildAction buildAction;
    private Map<String, PerformanceReport> performanceReportMap = new LinkedHashMap<String, PerformanceReport>();
    private static final String PERFORMANCE_REPORTS_DIRECTORY = "performance-reports";
    private static final String PLUGIN_NAME = "performance";
    private static final String TRENDREPORT_LINK = "trendReport";

    public PerformanceReportMap(PerformanceBuildAction buildAction, TaskListener listener) throws IOException {
        this(buildAction, listener, true);
    }

    public PerformanceReportMap(final PerformanceBuildAction buildAction, TaskListener listener, boolean isTopLevel) throws IOException {
        this.buildAction = buildAction;
        this.parseReports(this.getBuild(), listener, new PerformanceReportCollector(){

            @Override
            public void addAll(Collection<PerformanceReport> reports) {
                for (PerformanceReport r : reports) {
                    r.setBuildAction(buildAction);
                    PerformanceReportMap.this.performanceReportMap.put(r.getReportFileName(), r);
                }
            }
        }, null);
        if (isTopLevel) {
            this.addPreviousBuildReports();
        }
    }

    private void addAll(Collection<PerformanceReport> reports) {
        for (PerformanceReport r : reports) {
            r.setBuildAction(this.buildAction);
            this.performanceReportMap.put(r.getReportFileName(), r);
        }
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public List<PerformanceReport> getPerformanceListOrdered() {
        ArrayList<PerformanceReport> listPerformance = new ArrayList<PerformanceReport>(this.getPerformanceReportMap().values());
        Collections.sort(listPerformance);
        return listPerformance;
    }

    protected PerformancePublisher getPublisher() {
        Job job;
        Run<?, ?> build;
        if (this.buildAction != null && (build = this.buildAction.getBuild()) != null && (job = build.getParent()) instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            Describable describable = project.getPublishersList().get(PerformancePublisher.class);
            return describable != null ? (PerformancePublisher)describable : null;
        }
        return null;
    }

    public boolean ifModeThroughputUsed() {
        PerformancePublisher publisher = this.getPublisher();
        return publisher == null || publisher.isModeThroughput();
    }

    public boolean ifShowTrendGraphsUsed() {
        PerformancePublisher publisher = this.getPublisher();
        return publisher == null || publisher.isShowTrendGraphs();
    }

    public boolean ifModePerformancePerTestCaseUsed() {
        PerformancePublisher publisher = this.getPublisher();
        return publisher == null || publisher.isModePerformancePerTestCase();
    }

    public Map<String, PerformanceReport> getPerformanceReportMap() {
        return this.performanceReportMap;
    }

    public PerformanceReport getPerformanceReport(String performanceReportName) {
        return this.performanceReportMap.get(performanceReportName);
    }

    public UriReport getUriReport(String uriReport) {
        if (uriReport != null) {
            String uriReportDecoded;
            try {
                uriReportDecoded = URLDecoder.decode(uriReport.replace(".endperformanceparameter", ""), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
            StringTokenizer st = new StringTokenizer(uriReportDecoded, ":");
            return this.getPerformanceReportMap().get(st.nextToken()).getUriReportMap().get(st.nextToken());
        }
        return null;
    }

    public String getUrlName() {
        return PLUGIN_NAME;
    }

    public void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setPerformanceReportMap(Map<String, PerformanceReport> performanceReportMap) {
        this.performanceReportMap = performanceReportMap;
    }

    public static String getPerformanceReportFileRelativePath(String parserDisplayName, String reportFileName) {
        return PerformanceReportMap.getRelativePath(parserDisplayName, reportFileName);
    }

    public static String getPerformanceReportDirRelativePath() {
        return PerformanceReportMap.getRelativePath(new String[0]);
    }

    private static String getRelativePath(String ... suffixes) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(PERFORMANCE_REPORTS_DIRECTORY);
        for (String suffix : suffixes) {
            sb.append(File.separator).append(suffix);
        }
        return sb.toString();
    }

    public boolean isFailed(String performanceReportName) {
        return this.getPerformanceReport(performanceReportName) == null;
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("performanceReportPosition");
        Run<?, ?> previousBuild = this.getBuild();
        Map<Run<?, ?>, Map<String, PerformanceReport>> buildReports = this.getBuildReports(parameter, previousBuild);
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        ReportValueSelector valueSelector = ReportValueSelector.get(this.getBuild().getParent());
        String keyLabel = this.getKeyLabel(valueSelector.getGraphType());
        for (Map.Entry<Run<?, ?>, Map<String, PerformanceReport>> entry : buildReports.entrySet()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(entry.getKey());
            PerformanceReport report = entry.getValue().get(parameter);
            dataSetBuilder.add((Number)valueSelector.getValue(report), (Comparable)((Object)keyLabel), (Comparable)label);
        }
        String legendLimit = request.getParameter("legendLimit");
        final int limit = legendLimit != null && !legendLimit.isEmpty() ? Integer.parseInt(legendLimit) : Integer.MAX_VALUE;
        new Graph(-1L, 400, 200){

            protected JFreeChart createGraph() {
                return PerformanceReportMap.this.createRespondingTimeChart(dataSetBuilder.build(), limit);
            }
        }.doPng(request, response);
    }

    public void doThroughputGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("performanceReportPosition");
        if (parameter == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        RunList builds = this.buildAction.getBuild().getParent().getBuilds();
        for (Run build : builds) {
            PerformanceReport performanceReport;
            PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
            if (performanceBuildAction == null || (performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(parameter)) == null) continue;
            ThroughputReport throughputReport = new ThroughputReport(performanceReport);
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            dataSetBuilder.add((Number)throughputReport.get(), (Comparable)((Object)Messages.ProjectAction_RequestsPerSeconds()), (Comparable)label);
        }
        new Graph(-1L, 400, 200){

            protected JFreeChart createGraph() {
                return PerformanceReportMap.this.createThroughputChart(dataSetBuilder.build());
            }
        }.doPng(request, response);
    }

    protected JFreeChart createThroughputChart(CategoryDataset dataset) {
        return PerformanceProjectAction.createThroughputChart(dataset);
    }

    public void doRespondingTimeGraphPerTestCaseMode(StaplerRequest request, StaplerResponse response) throws IOException {
        String performanceReportNameFile = request.getParameter("performanceReportPosition");
        if (performanceReportNameFile == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        RunList builds = this.buildAction.getBuild().getParent().getBuilds();
        ReportValueSelector valueSelector = ReportValueSelector.get(this.getPublisher());
        for (Run build : builds) {
            PerformanceReport performanceReport;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
            if (performanceBuildAction == null || (performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile)) == null) continue;
            List<UriReport> uriListOrdered = performanceReport.getUriListOrdered();
            for (UriReport uriReport : uriListOrdered) {
                dataSetBuilder.add((Number)valueSelector.getValue(uriReport), (Comparable)((Object)uriReport.getUri()), (Comparable)label);
            }
        }
        String legendLimit = request.getParameter("legendLimit");
        final int limit = legendLimit != null && !legendLimit.isEmpty() ? Integer.parseInt(legendLimit) : Integer.MAX_VALUE;
        new Graph(-1L, 600, 200){

            protected JFreeChart createGraph() {
                return PerformanceReportMap.this.createRespondingTimeChart(dataSetBuilder.build(), limit);
            }
        }.doPng(request, response);
    }

    public void doErrorsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String performanceReportNameFile = request.getParameter("performanceReportPosition");
        if (performanceReportNameFile == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        final DataSetBuilder dataSetBuilderErrors = new DataSetBuilder();
        RunList builds = this.buildAction.getBuild().getParent().getBuilds();
        for (Run currentBuild : builds) {
            PerformanceReport performanceReport;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
            PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
            if (performanceBuildAction == null || (performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile)) == null) continue;
            dataSetBuilderErrors.add((Number)performanceReport.errorPercent(), (Comparable)((Object)Messages.ProjectAction_Errors()), (Comparable)label);
        }
        new Graph(-1L, 400, 200){

            protected JFreeChart createGraph() {
                return PerformanceReportMap.this.createErrorsChart(dataSetBuilderErrors.build());
            }
        }.doPng(request, response);
    }

    protected JFreeChart createErrorsChart(CategoryDataset dataset) {
        return PerformanceProjectAction.createErrorsChart(dataset);
    }

    protected JFreeChart createRespondingTimeChart(CategoryDataset dataset, int legendLimit) {
        return PerformanceProjectAction.doCreateRespondingTimeChart(dataset, legendLimit);
    }

    private String getKeyLabel(String configType) {
        if (configType.equals("MRT")) {
            return Messages.ProjectAction_Median();
        }
        if (configType.equals("PRT")) {
            return Messages.ProjectAction_Line90();
        }
        return Messages.ProjectAction_Average();
    }

    private Map<Run<?, ?>, Map<String, PerformanceReport>> getBuildReports(String parameter, Run<?, ?> previousBuild) throws IOException {
        final LinkedHashMap buildReports = new LinkedHashMap();
        while (previousBuild != null) {
            final Run currentBuild = previousBuild;
            this.parseReports(currentBuild, TaskListener.NULL, new PerformanceReportCollector(){

                @Override
                public void addAll(Collection<PerformanceReport> parse) {
                    for (PerformanceReport performanceReport : parse) {
                        if (buildReports.get(currentBuild) == null) {
                            LinkedHashMap map = new LinkedHashMap();
                            buildReports.put(currentBuild, map);
                        }
                        ((Map)buildReports.get(currentBuild)).put(performanceReport.getReportFileName(), performanceReport);
                    }
                }
            }, parameter);
            previousBuild = previousBuild.getPreviousCompletedBuild();
        }
        return buildReports;
    }

    public void doSummarizerGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("performanceReportPosition");
        Run<?, ?> previousBuild = this.getBuild();
        Map<Run<?, ?>, Map<String, PerformanceReport>> buildReports = this.getBuildReports(parameter, previousBuild);
        final DataSetBuilder dataSetBuilderSummarizer = new DataSetBuilder();
        ReportValueSelector valueSelector = ReportValueSelector.get(this.getBuild().getParent());
        for (Map.Entry<Run<?, ?>, Map<String, PerformanceReport>> entry : buildReports.entrySet()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(entry.getKey());
            PerformanceReport report = entry.getValue().get(parameter);
            for (Map.Entry<String, UriReport> secondEntry : report.getUriReportMap().entrySet()) {
                long methodValue = valueSelector.getValue(secondEntry.getValue());
                dataSetBuilderSummarizer.add((Number)methodValue, (Comparable)label, (Comparable)((Object)secondEntry.getKey()));
            }
        }
        new Graph(-1L, 400, 200){

            protected JFreeChart createGraph() {
                return PerformanceReportMap.this.createSummarizerChart(dataSetBuilderSummarizer.build());
            }
        }.doPng(request, response);
    }

    protected JFreeChart createSummarizerChart(CategoryDataset dataset) {
        return PerformanceProjectAction.doCreateSummarizerChart(dataset, "ms", Messages.ProjectAction_RespondingTime());
    }

    protected void parseReports(Run<?, ?> build, TaskListener listener, PerformanceReportCollector collector, final String filename) throws IOException {
        File[] dirs;
        File repo = new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportDirRelativePath());
        File[] files = repo.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && !f.getName().endsWith(".serialized");
            }
        });
        if (files != null) {
            this.addAll(new JMeterParser("", "0,50,90,95,100").parse(build, Arrays.asList(files), listener));
        }
        if ((dirs = repo.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            for (File dir : dirs) {
                PerformanceReportParser p = this.buildAction.getParserByDisplayName(dir.getName());
                if (p == null) continue;
                File[] listFiles = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (filename == null && !name.endsWith(".serialized")) {
                            return true;
                        }
                        return name.equals(filename);
                    }
                });
                if (listener == null || listener.getLogger() == null) continue;
                try {
                    collector.addAll(p.parse(build, Arrays.asList(listFiles), listener));
                }
                catch (IOException ex) {
                    listener.getLogger().println("Unable to process directory '" + String.valueOf(dir) + "'.");
                    ex.printStackTrace(listener.getLogger());
                }
            }
        }
    }

    private void addPreviousBuildReports() {
        for (Map.Entry<String, PerformanceReport> item : this.getPerformanceReportMap().entrySet()) {
            PerformanceReport curReport = item.getValue();
            int baselineBuild = curReport.getBaselineBuild();
            PerformanceReport reportForCompare = baselineBuild == 0 ? this.getPerformanceReportForBuild(this.getBuild().getPreviousCompletedBuild(), item.getKey()) : this.getPerformanceReportForBuild(this.getBuild(baselineBuild), item.getKey());
            if (reportForCompare == null) continue;
            curReport.setLastBuildReport(reportForCompare);
        }
    }

    protected PerformanceReportMap getReportMap(Run<?, ?> build) {
        if (build == null) {
            return null;
        }
        PerformanceBuildAction action = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
        if (action == null) {
            return null;
        }
        return action.getPerformanceReportMap(false);
    }

    protected PerformanceReport getPerformanceReportForBuild(Run<?, ?> build, String key) {
        PerformanceReportMap reportMap = this.getReportMap(build);
        if (reportMap == null) {
            return null;
        }
        return reportMap.getPerformanceReportMap().get(key);
    }

    protected Run<?, ?> getBuild(int buildNumber) {
        Run r;
        for (r = this.getBuild(); r != null && buildNumber != r.getNumber(); r = r.getPreviousBuild()) {
        }
        return r;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerRequest response) {
        if (TRENDREPORT_LINK.equals(link)) {
            return this.createTrendReportGraphs(request);
        }
        return null;
    }

    public Object createTrendReportGraphs(StaplerRequest request) {
        String filename = this.getTrendReportFilename(request);
        PerformanceReport report = this.performanceReportMap.get(filename);
        Run<?, ?> build = this.getBuild();
        if (build == null) {
            return null;
        }
        TrendReportGraphs trendReport = new TrendReportGraphs(build.getParent(), build, request, filename, report);
        return trendReport;
    }

    private String getTrendReportFilename(StaplerRequest request) {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        return performanceReportPosition.getPerformanceReportPosition();
    }

    protected static interface PerformanceReportCollector {
        public void addAll(Collection<PerformanceReport> var1);
    }
}

