/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.kohsuke.stapler.Stapler;

public abstract class AbstractReport {
    protected final DecimalFormat percentFormat;
    protected final DecimalFormat dataFormat;

    public abstract int countErrors();

    public abstract double errorPercent();

    public AbstractReport() {
        Locale useThisLocale = Stapler.getCurrentRequest() != null ? Stapler.getCurrentRequest().getLocale() : Locale.getDefault();
        this.percentFormat = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(useThisLocale));
        this.dataFormat = new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(useThisLocale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String errorPercentFormated() {
        Stapler.getCurrentRequest().getLocale();
        DecimalFormat decimalFormat = this.percentFormat;
        synchronized (decimalFormat) {
            return this.percentFormat.format(this.errorPercent());
        }
    }

    public abstract long getAverage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAverageFormated() {
        DecimalFormat decimalFormat = this.dataFormat;
        synchronized (decimalFormat) {
            return this.dataFormat.format(this.getAverage());
        }
    }

    public abstract long getMedian();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMeanFormated() {
        DecimalFormat decimalFormat = this.dataFormat;
        synchronized (decimalFormat) {
            return this.dataFormat.format(this.getMedian());
        }
    }

    public abstract long get90Line();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get90LineFormated() {
        DecimalFormat decimalFormat = this.dataFormat;
        synchronized (decimalFormat) {
            return this.dataFormat.format(this.get90Line());
        }
    }

    public abstract long getMax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaxFormated() {
        DecimalFormat decimalFormat = this.dataFormat;
        synchronized (decimalFormat) {
            return this.dataFormat.format(this.getMax());
        }
    }

    public abstract long getMin();

    public abstract int size();

    public abstract String getHttpCode();

    public abstract long getAverageDiff();

    public abstract long getMedianDiff();

    public abstract double getErrorPercentDiff();

    public abstract String getLastBuildHttpCodeIfChanged();

    public abstract int getSizeDiff();
}

