/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.performance.AbstractReport;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.PerformanceProjectAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class UriReport
extends AbstractReport
implements Serializable,
ModelObject,
Comparable<UriReport> {
    private static final long serialVersionUID = -5269155428479638524L;
    public static final String END_PERFORMANCE_PARAMETER = ".endperformanceparameter";
    private final String staplerUri;
    private UriReport lastBuildUriReport;
    private final PerformanceReport performanceReport;
    private String uri;
    private int nbError = 0;
    private final List<Sample> samples = new ArrayList<Sample>();
    private transient List<Long> durationsIO = new ArrayList<Long>();
    private transient List<Long> durationsSortedBySize = new ArrayList<Long>();
    private transient boolean isSorted = false;
    private long totalDuration = 0L;
    private Set<String> httpCodes = new HashSet<String>();
    private long summarizerSize = 0L;
    private float summarizerErrors = 0.0f;
    private Date start = null;
    private Date end = null;

    public UriReport(PerformanceReport performanceReport, String staplerUri, String uri) {
        this.performanceReport = performanceReport;
        this.staplerUri = staplerUri;
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSample(HttpSample sample) {
        if (!sample.isSuccessful()) {
            ++this.nbError;
        }
        List<Sample> list = this.samples;
        synchronized (list) {
            if (this.samples.add(new Sample(sample.getHttpCode(), sample.getDate(), sample.getDuration()))) {
                this.isSorted = false;
            }
        }
        this.totalDuration += sample.getDuration();
        this.httpCodes.add(sample.getHttpCode());
        this.summarizerSize += sample.getSummarizerSamples();
        this.summarizerErrors += sample.getSummarizerErrors();
        if (this.start == null || sample.getDate().before(this.start)) {
            this.start = sample.getDate();
        }
        Date finish = new Date(sample.getDate().getTime() + sample.getDuration());
        if (this.end == null || finish.after(this.end)) {
            this.end = finish;
        }
    }

    @Override
    public int compareTo(UriReport uriReport) {
        if (uriReport == this) {
            return 0;
        }
        return uriReport.getUri().compareTo(this.getUri());
    }

    @Override
    public int countErrors() {
        return this.nbError;
    }

    @Override
    public double errorPercent() {
        return (double)this.countErrors() / (double)this.size() * 100.0;
    }

    @Override
    public long getAverage() {
        return this.totalDuration / (long)this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDurationAt(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Argument 'percentage' must be a value between 0 and 1 (inclusive)");
        }
        List<Sample> list = this.samples;
        synchronized (list) {
            List<Long> durations = this.getSortedDuration();
            if (durations.isEmpty()) {
                return 0L;
            }
            return durations.get((int)((double)this.samples.size() * percentage));
        }
    }

    @Override
    public long get90Line() {
        return this.getDurationAt(0.9);
    }

    @Override
    public String getHttpCode() {
        return StringUtils.join(this.httpCodes, (char)',');
    }

    @Override
    public long getMedian() {
        return this.getDurationAt(0.5);
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.performanceReport.getBuild();
    }

    public String getDisplayName() {
        return this.getUri();
    }

    public List<Sample> getHttpSampleList() {
        return this.samples;
    }

    public PerformanceReport getPerformanceReport() {
        return this.performanceReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> getSortedDuration() {
        List<Sample> list = this.samples;
        synchronized (list) {
            if (!this.isSorted || this.durationsSortedBySize == null || this.durationsSortedBySize.size() != this.samples.size()) {
                this.durationsSortedBySize = new ArrayList<Long>(this.samples.size());
                for (Sample sample : this.samples) {
                    this.durationsSortedBySize.add(sample.duration);
                }
                Collections.sort(this.durationsSortedBySize);
                this.isSorted = true;
            }
            return this.durationsSortedBySize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getDurations() {
        List<Sample> list = this.samples;
        synchronized (list) {
            if (this.durationsIO == null || this.durationsIO.size() != this.samples.size()) {
                this.durationsIO = new ArrayList<Long>(this.samples.size());
                for (Sample sample : this.samples) {
                    this.durationsIO.add(sample.duration);
                }
            }
            return this.durationsIO;
        }
    }

    @Override
    public long getMax() {
        List<Long> durations = this.getSortedDuration();
        if (durations.isEmpty()) {
            return 0L;
        }
        return durations.get(durations.size() - 1);
    }

    @Override
    public long getMin() {
        List<Long> durations = this.getSortedDuration();
        if (durations.isEmpty()) {
            return 0L;
        }
        return durations.get(0);
    }

    public String getStaplerUri() {
        return this.staplerUri;
    }

    public String getUri() {
        return this.uri;
    }

    public String getShortUri() {
        if (this.uri.length() > 130) {
            return this.uri.substring(0, 129);
        }
        return this.uri;
    }

    public boolean isFailed() {
        return this.countErrors() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<Sample> list = this.samples;
        synchronized (list) {
            return this.samples.size();
        }
    }

    public String encodeUriReport() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.performanceReport.getReportFileName()).append(":").append(this.getStaplerUri()).append(END_PERFORMANCE_PARAMETER);
        return URLEncoder.encode(sb.toString(), "UTF-8");
    }

    public void addLastBuildUriReport(UriReport lastBuildUriReport) {
        this.lastBuildUriReport = lastBuildUriReport;
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildUriReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildUriReport.getMedian();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildUriReport == null) {
            return 0.0;
        }
        return this.errorPercent() - this.lastBuildUriReport.errorPercent();
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        if (this.lastBuildUriReport == null) {
            return "";
        }
        if (this.lastBuildUriReport.getHttpCode().equals(this.getHttpCode())) {
            return "";
        }
        return this.lastBuildUriReport.getHttpCode();
    }

    @Override
    public int getSizeDiff() {
        if (this.lastBuildUriReport == null) {
            return 0;
        }
        return this.size() - this.lastBuildUriReport.size();
    }

    public float getSummarizerErrors() {
        return this.summarizerErrors / (float)this.summarizerSize * 100.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSummarizerTrendGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        TimeSeries responseTimes = new TimeSeries((Comparable)((Object)"Response Time"), FixedMillisecond.class);
        List<Sample> list = this.samples;
        synchronized (list) {
            for (Sample sample : this.samples) {
                responseTimes.addOrUpdate((RegularTimePeriod)new FixedMillisecond(sample.date), (double)sample.duration);
            }
        }
        TimeSeriesCollection resp = new TimeSeriesCollection();
        resp.addSeries(responseTimes);
        ArrayList<XYDataset> dataset = new ArrayList<XYDataset>();
        dataset.add((XYDataset)resp);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createSummarizerTrend(dataset, this.uri), (int)400, (int)200);
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public static class Sample
    implements Serializable,
    Comparable<Sample> {
        private static final long serialVersionUID = 4458431861223813407L;
        final Date date;
        final long duration;
        final String httpCode;

        public Sample(String httpCode, Date date, long duration) {
            this.httpCode = httpCode;
            this.date = date;
            this.duration = duration;
        }

        public String getHttpCode() {
            return this.httpCode;
        }

        public Date getDate() {
            return this.date;
        }

        public long getDuration() {
            return this.duration;
        }

        @Override
        public int compareTo(Sample other) {
            if (this == other) {
                return 0;
            }
            if (this.duration < other.duration) {
                return -1;
            }
            if (this.duration > other.duration) {
                return 1;
            }
            if (this.date == null || other.date == null) {
                return 0;
            }
            if (this.date.before(other.date)) {
                return -1;
            }
            if (this.date.after(other.date)) {
                return 1;
            }
            return 0;
        }
    }
}

