/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceProjectAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportPosition;
import hudson.plugins.performance.UriReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.RunList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteReportDetail
implements ModelObject {
    private AbstractProject<?, ?> project;
    private String filename;
    private PerformanceProjectAction.Range buildsLimits;
    private transient List<String> performanceReportTestCaseList;

    public TestSuiteReportDetail(AbstractProject<?, ?> project, String pluginName, StaplerRequest request, String filename, PerformanceProjectAction.Range buildsLimits) {
        this.project = project;
        this.filename = filename;
        this.buildsLimits = buildsLimits;
    }

    public void doRespondingTimeGraphPerTestCaseMode(StaplerRequest request, StaplerResponse response) throws IOException {
        String testUri = request.getParameter("performanceReportTest");
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        String performanceReportNameFile = performanceReportPosition.getPerformanceReportPosition();
        if (performanceReportNameFile == null) {
            if (this.getPerformanceReportTestCaseList().size() == 1) {
                performanceReportNameFile = this.getPerformanceReportTestCaseList().get(0);
            } else {
                return;
            }
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(String.valueOf(request.getContextPath()) + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        PerformanceProjectAction.Range buildsLimits = this.buildsLimits;
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild build : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                if (!buildsLimits.includedByStep(build.number)) continue;
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(this.filename);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                String testStaplerUri = PerformanceReport.asStaplerURI(testUri);
                UriReport reportForTestUri = performanceReport.getUriReportMap().get(testStaplerUri);
                if (reportForTestUri != null) {
                    for (Long duration : reportForTestUri.getDurations()) {
                        dataSetBuilderAverage.add((Number)duration, (Comparable)((Object)testUri), (Comparable)label);
                    }
                }
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)TestSuiteReportDetail.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)600, (int)200);
    }

    protected static JFreeChart createRespondingTimeChart(CategoryDataset categoryDataset) {
        throw new Error("Unresolved compilation problem: \n\tMessages cannot be resolved\n");
    }

    public List<String> getPerformanceReportTestCaseList() {
        this.performanceReportTestCaseList = new ArrayList<String>(0);
        String performanceReportNameFile = this.getFilename();
        RunList builds = this.getProject().getBuilds();
        builds.size();
        for (AbstractBuild build : builds) {
            PerformanceReport performanceReport;
            PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
            if (performanceBuildAction == null || (performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile)) == null) continue;
            for (UriReport currentReport : performanceReport.getUriReportMap().values()) {
                if (this.performanceReportTestCaseList.contains(currentReport.getUri())) continue;
                this.performanceReportTestCaseList.add(currentReport.getUri());
            }
        }
        Collections.sort(this.performanceReportTestCaseList);
        return this.performanceReportTestCaseList;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDisplayName() {
        throw new Error("Unresolved compilation problem: \n\tMessages cannot be resolved\n");
    }
}

