/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.performance.GraphConfigurationDetail;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.plugins.performance.PerformanceReportPosition;
import hudson.plugins.performance.TestSuiteReportDetail;
import hudson.plugins.performance.ThroughputReport;
import hudson.plugins.performance.TrendReportDetail;
import hudson.plugins.performance.UriReport;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerformanceProjectAction
implements Action {
    private static final String CONFIGURE_LINK = "configure";
    private static final String TRENDREPORT_LINK = "trendReport";
    private static final String TESTSUITE_LINK = "testsuiteReport";
    private static final String PLUGIN_NAME = "performance";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PerformanceProjectAction.class.getName());
    public final AbstractProject<?, ?> project;
    private transient List<String> performanceReportList;

    public String getDisplayName() {
        return Messages.ProjectAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return PLUGIN_NAME;
    }

    public PerformanceProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    private JFreeChart createErrorsChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)Messages.ProjectAction_PercentageOfErrors(), null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    protected static JFreeChart createRespondingTimeChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)Messages.ProjectAction_RespondingTime(), null, (String)"ms", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    protected static JFreeChart createThroughputChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)Messages.ProjectAction_Throughput(), null, (String)Messages.ProjectAction_RequestsPerSeconds(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    protected static JFreeChart createSummarizerChart(CategoryDataset dataset, String yAxis, String chartTitle) {
        JFreeChart chart = ChartFactory.createBarChart((String)chartTitle, null, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        renderer.setItemMargin(0.0);
        renderer.setMaximumBarWidth(0.05);
        return chart;
    }

    protected static JFreeChart createSummarizerTrend(ArrayList<XYDataset> dataset, String uri) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)uri, (String)"Time", (String)"Response Time", (XYDataset)dataset.get(0), (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm:ss"));
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ColorPalette.RED);
        return chart;
    }

    private String getPerformanceReportNameFile(StaplerRequest request) {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        return this.getPerformanceReportNameFile(performanceReportPosition);
    }

    private String getPerformanceReportNameFile(PerformanceReportPosition performanceReportPosition) {
        String performanceReportNameFile = performanceReportPosition.getPerformanceReportPosition();
        if (performanceReportNameFile == null && this.getPerformanceReportList().size() == 1) {
            performanceReportNameFile = this.getPerformanceReportList().get(0);
        }
        return performanceReportNameFile;
    }

    public void doErrorsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String performanceReportNameFile = this.getPerformanceReportNameFile(request);
        if (performanceReportNameFile == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderErrors = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                if (!buildsLimits.includedByStep(currentBuild.number)) continue;
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSetBuilderErrors.add((Number)performanceReport.errorPercent(), (Comparable)((Object)Messages.ProjectAction_Errors()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createErrorsChart(dataSetBuilderErrors.build()), (int)400, (int)200);
    }

    public void doRespondingTimeGraphPerTestCaseMode(StaplerRequest request, StaplerResponse response) throws IOException {
        String performanceReportNameFile = this.getPerformanceReportNameFile(request);
        if (performanceReportNameFile == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild build : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                PerformanceBuildAction performanceBuildAction;
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
                if (!buildsLimits.includedByStep(build.number) || (performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class)) == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                List<UriReport> uriListOrdered = performanceReport.getUriListOrdered();
                for (UriReport uriReport : uriListOrdered) {
                    dataSetBuilderAverage.add((Number)uriReport.getAverage(), (Comparable)((Object)uriReport.getUri()), (Comparable)label);
                }
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)600, (int)200);
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String performanceReportNameFile = this.getPerformanceReportNameFile(request);
        if (performanceReportNameFile == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild build : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                if (!buildsLimits.includedByStep(build.number)) continue;
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSetBuilderAverage.add((Number)performanceReport.getMedian(), (Comparable)((Object)Messages.ProjectAction_Median()), (Comparable)label);
                dataSetBuilderAverage.add((Number)performanceReport.getAverage(), (Comparable)((Object)Messages.ProjectAction_Average()), (Comparable)label);
                dataSetBuilderAverage.add((Number)performanceReport.get90Line(), (Comparable)((Object)Messages.ProjectAction_Line90()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)400, (int)200);
    }

    public void doThroughputGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String performanceReportNameFile = this.getPerformanceReportNameFile(request);
        if (performanceReportNameFile == null) {
            return;
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild build : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                PerformanceBuildAction performanceBuildAction;
                if (!buildsLimits.includedByStep(build.number) || (performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class)) == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                ThroughputReport throughputReport = new ThroughputReport(performanceReport);
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
                dataSetBuilder.add((Number)throughputReport.get(), (Comparable)((Object)Messages.ProjectAction_RequestsPerSeconds()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createThroughputChart(dataSetBuilder.build()), (int)400, (int)200);
    }

    public void doSummarizerGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        String performanceReportNameFile = this.getPerformanceReportNameFile(performanceReportPosition);
        if (ChartUtil.awtProblemCause != null) {
            return;
        }
        DataSetBuilder dataSetBuilderSummarizer = new DataSetBuilder();
        DataSetBuilder dataSetBuilderSummarizerErrors = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport performanceReport = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (performanceReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                for (Map.Entry<String, UriReport> entry : performanceReport.getUriReportMap().entrySet()) {
                    Long methodAvg = entry.getValue().getAverage();
                    float methodErrors = entry.getValue().getSummarizerErrors();
                    dataSetBuilderSummarizer.add((Number)methodAvg, (Comparable)label, (Comparable)((Object)entry.getKey()));
                    dataSetBuilderSummarizerErrors.add((Number)Float.valueOf(methodErrors), (Comparable)label, (Comparable)((Object)entry.getKey()));
                }
            }
            --nbBuildsToAnalyze;
        }
        String summarizerReportType = performanceReportPosition.getSummarizerReportType();
        if (summarizerReportType != null) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createSummarizerChart(dataSetBuilderSummarizerErrors.build(), "%", Messages.ProjectAction_PercentageOfErrors()), (int)400, (int)200);
        } else {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createSummarizerChart(dataSetBuilderSummarizer.build(), "ms", Messages.ProjectAction_RespondingTime()), (int)400, (int)200);
        }
    }

    private Range getFirstAndLastBuild(StaplerRequest request, List<?> builds) {
        GraphConfigurationDetail graphConf = (GraphConfigurationDetail)this.createUserConfiguration(request);
        if (graphConf.isNone()) {
            return this.all(builds);
        }
        if (graphConf.isBuildCount()) {
            if (graphConf.getBuildCount() <= 0) {
                return this.all(builds);
            }
            int first = builds.size() - graphConf.getBuildCount();
            return new Range(first > 0 ? first + 1 : 1, builds.size());
        }
        if (graphConf.isBuildNth()) {
            if (graphConf.getBuildStep() <= 0) {
                return this.all(builds);
            }
            return new Range(1, builds.size(), graphConf.getBuildStep());
        }
        if (graphConf.isDate()) {
            if (graphConf.isDefaultDates()) {
                return this.all(builds);
            }
            int firstBuild = -1;
            int lastBuild = -1;
            int var = builds.size();
            GregorianCalendar firstDate = null;
            GregorianCalendar lastDate = null;
            try {
                firstDate = GraphConfigurationDetail.getGregorianCalendarFromString(graphConf.getFirstDayCount());
                lastDate = GraphConfigurationDetail.getGregorianCalendarFromString(graphConf.getLastDayCount());
                lastDate.set(11, 23);
                lastDate.set(12, 59);
                lastDate.set(13, 59);
            }
            catch (ParseException e) {
                LOGGER.log(Level.SEVERE, "Error during the manage of the Calendar", e);
            }
            for (AbstractBuild currentBuild : builds) {
                GregorianCalendar buildDate = new GregorianCalendar();
                buildDate.setTime(currentBuild.getTimestamp().getTime());
                if (firstDate.getTime().before(buildDate.getTime())) {
                    firstBuild = var;
                }
                if (lastBuild < 0 && lastDate.getTime().after(buildDate.getTime())) {
                    lastBuild = var;
                }
                --var;
            }
            return new Range(firstBuild, lastBuild);
        }
        throw new IllegalArgumentException("unsupported configType + " + graphConf.getConfigType());
    }

    public Range all(List<?> builds) {
        return new Range(1, builds.size());
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public List<String> getPerformanceReportList() {
        this.performanceReportList = new ArrayList<String>(0);
        if (null == this.project) {
            return this.performanceReportList;
        }
        if (null == this.project.getSomeBuildWithWorkspace()) {
            return this.performanceReportList;
        }
        File file = new File(this.project.getSomeBuildWithWorkspace().getRootDir(), PerformanceReportMap.getPerformanceReportDirRelativePath());
        if (!file.isDirectory()) {
            return this.performanceReportList;
        }
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                for (File e : entry.listFiles()) {
                    if (e.getName().endsWith(".serialized") || e.getName().endsWith(".serialized-v2")) continue;
                    this.performanceReportList.add(e.getName());
                }
                continue;
            }
            if (entry.getName().endsWith(".serialized") || entry.getName().endsWith(".serialized-v2")) continue;
            this.performanceReportList.add(entry.getName());
        }
        Collections.sort(this.performanceReportList);
        return this.performanceReportList;
    }

    public void setPerformanceReportList(List<String> performanceReportList) {
        this.performanceReportList = performanceReportList;
    }

    public boolean isTrendVisibleOnProjectDashboard() {
        return this.getPerformanceReportList() != null && this.getPerformanceReportList().size() == 1;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (CONFIGURE_LINK.equals(link)) {
            return this.createUserConfiguration(request);
        }
        if (TRENDREPORT_LINK.equals(link)) {
            return this.createTrendReport(request);
        }
        if (TESTSUITE_LINK.equals(link)) {
            return this.createTestsuiteReport(request);
        }
        return null;
    }

    private Object createUserConfiguration(StaplerRequest request) {
        GraphConfigurationDetail graph = new GraphConfigurationDetail(this.project, PLUGIN_NAME, request);
        return graph;
    }

    private Object createTrendReport(StaplerRequest request) {
        String filename = this.getTrendReportFilename(request);
        CategoryDataset dataSet = this.getTrendReportData(request, filename).build();
        TrendReportDetail report = new TrendReportDetail(this.project, PLUGIN_NAME, request, filename, dataSet);
        return report;
    }

    private Object createTestsuiteReport(StaplerRequest request) {
        String filename = this.getTestSuiteReportFilename(request);
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        TestSuiteReportDetail report = new TestSuiteReportDetail(this.project, PLUGIN_NAME, request, filename, buildsLimits);
        return report;
    }

    private String getTrendReportFilename(StaplerRequest request) {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        return performanceReportPosition.getPerformanceReportPosition();
    }

    private String getTestSuiteReportFilename(StaplerRequest request) {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        return performanceReportPosition.getPerformanceReportPosition();
    }

    private DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getTrendReportData(StaplerRequest request, String performanceReportNameFile) {
        DataSetBuilder dataSet = new DataSetBuilder();
        RunList builds = this.getProject().getBuilds();
        Range buildsLimits = this.getFirstAndLastBuild(request, (List<?>)builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (buildsLimits.in(nbBuildsToAnalyze)) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)currentBuild.getAction(PerformanceBuildAction.class);
                if (performanceBuildAction == null) continue;
                PerformanceReport report = null;
                report = performanceBuildAction.getPerformanceReportMap().getPerformanceReport(performanceReportNameFile);
                if (report == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSet.add((Number)Math.round(report.getAverage()), (Comparable)((Object)Messages.ProjectAction_Average()), (Comparable)label);
                dataSet.add((Number)Math.round(report.getMedian()), (Comparable)((Object)Messages.ProjectAction_Median()), (Comparable)label);
                dataSet.add((Number)Math.round(report.get90Line()), (Comparable)((Object)Messages.ProjectAction_Line90()), (Comparable)label);
                dataSet.add((Number)Math.round(report.getMin()), (Comparable)((Object)Messages.ProjectAction_Minimum()), (Comparable)label);
                dataSet.add((Number)Math.round(report.getMax()), (Comparable)((Object)Messages.ProjectAction_Maximum()), (Comparable)label);
                dataSet.add((Number)Math.round(report.errorPercent()), (Comparable)((Object)Messages.ProjectAction_PercentageOfErrors()), (Comparable)label);
                dataSet.add((Number)Math.round(report.countErrors()), (Comparable)((Object)Messages.ProjectAction_Errors()), (Comparable)label);
                dataSet.add((Number)report.getTotalTrafficInKb(), (Comparable)((Object)Messages.ProjectAction_TotalTrafficKB()), (Comparable)label);
                dataSet.add((Number)report.getAverageSizeInKb(), (Comparable)((Object)Messages.ProjectAction_AverageKB()), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        return dataSet;
    }

    public boolean ifSummarizerParserUsed(String filename) {
        return ((PerformanceBuildAction)((AbstractBuild)this.getProject().getBuilds().getLastBuild()).getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceReport(filename).ifSummarizerParserUsed(filename);
    }

    public boolean ifModePerformancePerTestCaseUsed() {
        return ((PerformancePublisher)this.project.getPublishersList().get(PerformancePublisher.class)).isModePerformancePerTestCase();
    }

    public boolean ifModeThroughputUsed() {
        return ((PerformancePublisher)this.project.getPublishersList().get(PerformancePublisher.class)).isModeThroughput();
    }

    public static class Range {
        public int first;
        public int last;
        public int step;

        public Range(int first, int last) {
            this.first = first;
            this.last = last;
            this.step = 1;
        }

        public Range(int first, int last, int step) {
            this(first, last);
            this.step = step;
        }

        public boolean in(int nbBuildsToAnalyze) {
            return nbBuildsToAnalyze <= this.last && this.first <= nbBuildsToAnalyze;
        }

        public boolean includedByStep(int buildNumber) {
            return buildNumber % this.step == 0;
        }
    }
}

