/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.plugins.performance.AbstractParser;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.xml.sax.SAXException;

public class JMeterCsvParser
extends AbstractParser {
    public final boolean skipFirstLine;
    public final String delimiter;
    public int timestampIdx = -1;
    public int elapsedIdx = -1;
    public int responseCodeIdx = -1;
    public int successIdx = -1;
    public int urlIdx = -1;
    public final String pattern;

    @DataBoundConstructor
    public JMeterCsvParser(String glob, String pattern, String delimiter, Boolean skipFirstLine) throws Exception {
        super(glob);
        this.skipFirstLine = skipFirstLine;
        this.delimiter = delimiter;
        this.pattern = pattern;
        String[] fields = pattern.split(delimiter);
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if ("timestamp".equals(field)) {
                this.timestampIdx = i;
                continue;
            }
            if ("elapsed".equals(field)) {
                this.elapsedIdx = i;
                continue;
            }
            if ("responseCode".equals(field)) {
                this.responseCodeIdx = i;
                continue;
            }
            if ("success".equals(field)) {
                this.successIdx = i;
                continue;
            }
            if (!"URL".equals(field)) continue;
            this.urlIdx = i;
        }
        if (this.timestampIdx < 0 || this.elapsedIdx < 0 || this.responseCodeIdx < 0 || this.successIdx < 0 || this.urlIdx < 0) {
            throw new Exception("Missing required column");
        }
    }

    public String getDefaultGlobPattern() {
        return "**/*.csv";
    }

    public String getDefaultPattern() {
        return "timestamp,elapsed,responseCode,threadName,success,failureMessage,grpThreads,allThreads,URL,Latency,SampleCount,ErrorCount";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = new PerformanceReport();
        report.setReportFileName(reportFile.getName());
        BufferedReader reader = new BufferedReader(new FileReader(reportFile));
        try {
            String line = reader.readLine();
            if (line != null && this.skipFirstLine) {
                line = reader.readLine();
            }
            while (line != null) {
                HttpSample sample = this.getSample(line);
                if (sample != null) {
                    try {
                        report.addSample(sample);
                    }
                    catch (SAXException e) {
                        throw new RuntimeException("Error parsing file '" + reportFile + "': Unable to add sample for line " + line, e);
                    }
                }
                line = reader.readLine();
            }
            PerformanceReport performanceReport = report;
            return performanceReport;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private HttpSample getSample(String line) {
        HttpSample sample = new HttpSample();
        String commasNotInsideQuotes = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
        String[] values = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        sample.setDate(new Date(Long.valueOf(values[this.timestampIdx])));
        sample.setDuration(Long.valueOf(values[this.elapsedIdx]));
        sample.setHttpCode(values[this.responseCodeIdx]);
        sample.setSuccessful(Boolean.valueOf(values[this.successIdx]));
        sample.setUri(values[this.urlIdx]);
        return sample;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeterCSV";
        }

        public FormValidation doCheckDelimiter(@QueryParameter String delimiter) {
            if (delimiter == null || delimiter.isEmpty()) {
                return FormValidation.error((String)Messages.CsvParser_validation_delimiterEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPattern(@QueryParameter String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                FormValidation.error((String)Messages.CsvParser_validation_patternEmpty());
            }
            HashSet<String> missing = new HashSet<String>();
            this.validatePresent(missing, pattern, "timestamp");
            this.validatePresent(missing, pattern, "elapsed");
            this.validatePresent(missing, pattern, "responseCode");
            this.validatePresent(missing, pattern, "success");
            this.validatePresent(missing, pattern, "URL");
            if (missing.isEmpty()) {
                return FormValidation.ok();
            }
            StringBuilder builder = new StringBuilder();
            for (String field : missing) {
                builder.append(field + ", ");
            }
            builder.setLength(builder.length() - 2);
            return FormValidation.error((String)(Messages.CsvParser_validation_MissingFields() + ": " + builder.toString()));
        }

        private void validatePresent(Set<String> missing, String pattern, String string) {
            if (!pattern.contains(string)) {
                missing.add(string);
            }
        }
    }
}

