/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.plugins.performance.CookieHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphConfigurationDetail
implements ModelObject {
    private static final Logger LOGGER = Logger.getLogger(GraphConfigurationDetail.class.getName());
    public static final String LEGACY_SEPARATOR = ";";
    public static final String SEPARATOR = ":";
    private int buildCount;
    private String firstDayCount;
    private String lastDayCount;
    private String configType;
    private int buildStep;
    public static final int DEFAULT_COUNT = 0;
    public static final int DEFAULT_STEP = 1;
    public static final String DEFAULT_DATE = "dd/MM/yyyy";
    public static final String NONE_CONFIG = "NONE";
    public static final String BUILD_CONFIG = "BUILD";
    public static final String DATE_CONFIG = "DATE";
    public static final String BUILDNTH_CONFIG = "BUILDNTH";
    static DateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    public boolean isNone() {
        return this.configType.compareToIgnoreCase(NONE_CONFIG) == 0;
    }

    public boolean isBuildCount() {
        return this.configType.compareToIgnoreCase(BUILD_CONFIG) == 0;
    }

    public boolean isBuildNth() {
        return this.configType.compareToIgnoreCase(BUILDNTH_CONFIG) == 0;
    }

    public boolean isDate() {
        return this.configType.compareToIgnoreCase(DATE_CONFIG) == 0;
    }

    public boolean isDefaultDates() {
        return DEFAULT_DATE.compareTo(this.firstDayCount) == 0 && DEFAULT_DATE.compareTo(this.lastDayCount) == 0;
    }

    public GraphConfigurationDetail(AbstractProject<?, ?> project, String pluginName, StaplerRequest request) {
        String value = GraphConfigurationDetail.createCookieHandler(pluginName).getValue(request.getCookies());
        List<Integer> initializationListResult = this.initializeFrom(value);
        if (!initializationListResult.isEmpty()) {
            File defaultsFile = GraphConfigurationDetail.createDefaultsFile(project, pluginName);
            if (defaultsFile.exists()) {
                String defaultValue = this.readFromDefaultsFile(defaultsFile);
                initializationListResult = this.initializeFrom(defaultValue);
                if (!initializationListResult.isEmpty()) {
                    this.reset(initializationListResult);
                }
            } else {
                this.reset(initializationListResult);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void doSave(StaplerRequest request, StaplerResponse response) {
        try {
            try {
                String buildStepString;
                JSONObject formData = request.getSubmittedForm();
                String buildCountString = formData.getString("buildCountString");
                int buildCount = 0;
                if (StringUtils.isNotBlank((String)buildCountString)) {
                    buildCount = formData.getInt("buildCountString");
                }
                String firstDayCountString = formData.getString("firstDayCountString");
                String firstDayCount = DEFAULT_DATE;
                if (StringUtils.isNotBlank((String)firstDayCountString)) {
                    firstDayCount = formData.getString("firstDayCountString");
                }
                String lastDayCountString = formData.getString("lastDayCountString");
                String lastDayCount = DEFAULT_DATE;
                if (StringUtils.isNotBlank((String)lastDayCountString)) {
                    lastDayCount = formData.getString("lastDayCountString");
                }
                String radioConfigType = formData.getString("radioConfigType");
                String configType = NONE_CONFIG;
                if (StringUtils.isNotBlank((String)radioConfigType)) {
                    configType = formData.getString("radioConfigType");
                }
                int buildStep = 1;
                if (formData.has("buildStepString") && StringUtils.isNotBlank((String)(buildStepString = formData.getString("buildStepString")))) {
                    buildStep = formData.getInt("buildStepString");
                }
                String value = this.serializeToString(configType, buildCount, firstDayCount, lastDayCount, buildStep);
                this.persistValue(value, request, response);
            }
            catch (JSONException exception) {
                LOGGER.log(Level.SEVERE, "Can't parse the form data: " + request, exception);
                try {
                    response.sendRedirect("../");
                }
                catch (IOException exception2) {
                    LOGGER.log(Level.SEVERE, "Can't redirect", exception2);
                }
            }
            catch (IllegalArgumentException exception) {
                LOGGER.log(Level.SEVERE, "Can't parse the form data: " + request, exception);
                try {
                    response.sendRedirect("../");
                }
                catch (IOException exception3) {
                    LOGGER.log(Level.SEVERE, "Can't redirect", exception3);
                }
            }
            catch (ServletException exception) {
                LOGGER.log(Level.SEVERE, "Can't process the form data: " + request, exception);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    response.sendRedirect("../");
                }
                catch (IOException exception4) {
                    LOGGER.log(Level.SEVERE, "Can't redirect", exception4);
                }
            }
        }
        finally {
            try {
                response.sendRedirect("../");
            }
            catch (IOException exception) {
                LOGGER.log(Level.SEVERE, "Can't redirect", exception);
            }
        }
    }

    public String getDisplayName() {
        throw new Error("Unresolved compilation problem: \n\tMessages cannot be resolved\n");
    }

    private static CookieHandler createCookieHandler(String cookieName) {
        return new CookieHandler(cookieName);
    }

    protected void persistValue(String value, StaplerRequest request, StaplerResponse response) {
        String buildCount = request.getParameter("buildCount");
        if (buildCount != null) {
            this.setBuildCount(Integer.parseInt(buildCount));
            this.setConfigType(BUILD_CONFIG);
            return;
        }
        String buildStep = request.getParameter("buildStep");
        if (buildStep != null) {
            this.setBuildStep(Integer.parseInt(buildStep));
            this.setConfigType(BUILDNTH_CONFIG);
            return;
        }
        Cookie cookie = GraphConfigurationDetail.createCookieHandler("performance").create(request.getAncestors(), value);
        response.addCookie(cookie);
    }

    protected String serializeToString(String configType, int buildCount, String firstDayCount, String lastDayCount, int buildStep) {
        return String.valueOf(configType) + SEPARATOR + buildCount + SEPARATOR + firstDayCount + SEPARATOR + lastDayCount + SEPARATOR + buildStep;
    }

    protected static File createDefaultsFile(AbstractProject<?, ?> project, String pluginName) {
        return new File(project.getRootDir(), String.valueOf(pluginName) + ".txt");
    }

    private List<Integer> initializeFrom(String value) {
        ArrayList<Integer> listErrors = new ArrayList<Integer>(0);
        if (StringUtils.isBlank((String)value)) {
            listErrors.add(-1);
            return listErrors;
        }
        String[] values = value.contains(LEGACY_SEPARATOR) ? StringUtils.split((String)value, (String)LEGACY_SEPARATOR) : StringUtils.split((String)value, (String)SEPARATOR);
        if (values.length != 4 && values.length != 5) {
            listErrors.add(-1);
            return listErrors;
        }
        this.configType = values[0];
        if (BUILD_CONFIG.compareToIgnoreCase(this.configType) != 0 && BUILDNTH_CONFIG.compareToIgnoreCase(this.configType) != 0 && DATE_CONFIG.compareToIgnoreCase(this.configType) != 0 && NONE_CONFIG.compareToIgnoreCase(this.configType) != 0) {
            listErrors.add(-1);
        }
        try {
            this.buildCount = Integer.parseInt(values[1]);
        }
        catch (JSONException e) {
            listErrors.add(1);
            e.printStackTrace();
        }
        this.firstDayCount = values[2];
        this.lastDayCount = values[3];
        GregorianCalendar firstDate = null;
        GregorianCalendar lastDate = null;
        if (this.firstDayCount.compareTo(DEFAULT_DATE) == 0 && DATE_CONFIG.compareToIgnoreCase(this.configType) == 0) {
            listErrors.add(2);
        }
        if (this.lastDayCount.compareTo(DEFAULT_DATE) == 0 && DATE_CONFIG.compareToIgnoreCase(this.configType) == 0) {
            listErrors.add(3);
        }
        if (this.firstDayCount.compareTo(DEFAULT_DATE) != 0) {
            try {
                firstDate = GraphConfigurationDetail.getGregorianCalendarFromString(this.firstDayCount);
            }
            catch (IllegalArgumentException e) {
                listErrors.add(2);
                e.printStackTrace();
            }
            catch (ParseException e) {
                listErrors.add(2);
                e.printStackTrace();
            }
        }
        if (this.lastDayCount.compareTo(DEFAULT_DATE) != 0) {
            try {
                lastDate = GraphConfigurationDetail.getGregorianCalendarFromString(this.lastDayCount);
            }
            catch (IllegalArgumentException e) {
                listErrors.add(3);
                e.printStackTrace();
            }
            catch (ParseException e) {
                listErrors.add(3);
                e.printStackTrace();
            }
        }
        if (firstDate != null && lastDate != null && firstDate.after(lastDate)) {
            listErrors.add(2);
            listErrors.add(3);
        }
        try {
            if (values.length == 5) {
                this.buildStep = Integer.parseInt(values[4]);
            }
        }
        catch (JSONException e) {
            listErrors.add(4);
            e.printStackTrace();
        }
        if (!listErrors.isEmpty()) {
            Collections.sort(listErrors);
            if ((Integer)listErrors.get(0) == -1) {
                listErrors = new ArrayList(1);
                listErrors.add(-1);
            } else {
                int actualErrorType = 0;
                ArrayList<Integer> realListErrors = new ArrayList<Integer>(0);
                for (Integer typeError : listErrors) {
                    if (actualErrorType == typeError) continue;
                    actualErrorType = typeError;
                    realListErrors.add(typeError);
                }
                listErrors = realListErrors;
            }
        }
        return listErrors;
    }

    public static GregorianCalendar getGregorianCalendarFromString(String dateString) throws ParseException {
        Date date = format.parse(dateString);
        GregorianCalendar outCalendar = new GregorianCalendar();
        outCalendar.setTime(date);
        return outCalendar;
    }

    private void reset(List<Integer> initializationResult) {
        this.configType = NONE_CONFIG;
        for (Integer errorNumber : initializationResult) {
            if (errorNumber == -1) {
                this.buildCount = 0;
                this.firstDayCount = DEFAULT_DATE;
                this.lastDayCount = DEFAULT_DATE;
                this.buildStep = 1;
                continue;
            }
            if (errorNumber == 1) {
                this.buildCount = 0;
                continue;
            }
            if (errorNumber == 2) {
                this.firstDayCount = DEFAULT_DATE;
                continue;
            }
            if (errorNumber == 3) {
                this.lastDayCount = DEFAULT_DATE;
                continue;
            }
            if (errorNumber != 4) continue;
            this.buildStep = 1;
        }
    }

    private String readFromDefaultsFile(File defaultsFile) {
        String defaultValue;
        block5: {
            defaultValue = "";
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(defaultsFile);
                    defaultValue = IOUtils.toString((InputStream)input);
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(input);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        return defaultValue;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public void setBuildCount(int buildCount) {
        this.buildCount = buildCount;
    }

    public int getBuildStep() {
        return this.buildStep;
    }

    public void setBuildStep(int buildStep) {
        this.buildStep = buildStep;
    }

    public String getFirstDayCount() {
        return this.firstDayCount;
    }

    public void setFirstDayCount(String firstDayCount) {
        this.firstDayCount = firstDayCount;
    }

    public String getLastDayCount() {
        return this.lastDayCount;
    }

    public void setLastDayCount(String lastDayCount) {
        this.lastDayCount = lastDayCount;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }
}

