/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Scanner;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrkSummarizerParser
extends PerformanceReportParser {
    @DataBoundConstructor
    public WrkSummarizerParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.wrk";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        result = new ArrayList<PerformanceReport>(reports.size());
        logger = listener.getLogger();
        for (File f : reports) {
            r = new PerformanceReport();
            s = null;
            try {
                sample = new HttpSample();
                r.setReportFileName(f.getName());
                logger.println("Performance: Parsing WrkSummarizer report file " + f.getName());
                s = new Scanner(f);
lbl11:
                // 10 sources

                block19: while (s.hasNextLine()) {
                    scanner = null;
                    try {
                        line = s.nextLine();
                        scanner = new Scanner(line.toLowerCase().replaceAll("(\\d)s|ms|%|mb|kb(\\b)", "$1$2"));
                        firstToken = scanner.next();
                        secondToken = scanner.next();
                        switch (1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[this.determineLineType(firstToken, secondToken).ordinal()]) {
                            case 1: {
                                scanner.next();
                                scanner.next();
                                uri = scanner.next();
                                sample.setUri(uri);
                                ** break;
                            }
                            case 2: {
                                latencyScanner = new Scanner(line.toLowerCase());
                                latencyScanner.next();
                                latencyAvg = this.getTime(latencyScanner.next(), logger, TimeUnit.MILLISECOND);
                                latencyScanner.next();
                                latencyMax = this.getTime(latencyScanner.next(), logger, TimeUnit.MILLISECOND);
                                sample.setDuration(latencyAvg);
                                sample.setSummarizerMax(latencyMax);
                                ** break;
                            }
                            case 3: {
                                ** break;
                            }
                            case 4: {
                                totalReq = Long.parseLong(firstToken);
                                summaryScanner = new Scanner(line.toLowerCase());
                                summaryScanner.next();
                                summaryScanner.next();
                                summaryScanner.next();
                                sample.setSummarizerSamples(totalReq);
                                summaryScanner.close();
                                ** break;
                            }
                            case 5: {
                                scanner.next();
                                scanner.next();
                                numErrors = scanner.nextInt();
                                sample.setSummarizerErrors(numErrors);
                                ** break;
                            }
                            case 6: 
                            case 7: {
                                ** break;
                            }
                            ** default:
lbl63:
                            // 1 sources

                            continue block19;
                        }
                    }
                    finally {
                        if (scanner == null) continue;
                        scanner.close();
                    }
                }
                sample.setSuccessful(true);
                sample.setDate(new Date());
                r.addSample(sample);
            }
            catch (FileNotFoundException e) {
                logger.println("Performance: File not found " + e.getMessage());
            }
            catch (SAXException e) {
                logger.println("Performance: " + e.getMessage());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            result.add(r);
        }
        return result;
    }

    public long getTime(String timeString, PrintStream logger, TimeUnit tu) {
        double factor = 0.0;
        long time = 0L;
        timeString = timeString.trim().replaceAll("[^\\d\\.smh]", "");
        String timeUnitString = timeString.replaceAll("[\\d\\.]", "");
        String timeValueString = timeString.replaceAll("[smh]", "");
        if (timeUnitString.equals("ms")) {
            factor = 1.0;
        } else if (timeUnitString.equals("s")) {
            factor = 1000.0;
        } else if (timeUnitString.equals("m")) {
            factor = 60000.0;
        } else if (timeUnitString.equals("h")) {
            factor = 3600000.0;
        }
        try {
            double timeValue = Double.parseDouble(timeValueString);
            double timeInMilliSeconds = timeValue * factor;
            double timeInReturnFormat = timeInMilliSeconds / (double)tu.getFactor();
            time = (int)Math.floor(timeInReturnFormat);
        }
        catch (NumberFormatException e) {
            logger.println("Performance: Unable to parse output: " + timeString);
        }
        catch (Exception e) {
            logger.println("Performance: " + e.getMessage());
        }
        return time;
    }

    /*
     * Loose catch block
     */
    public LineType determineLineType(String t1, String t2) {
        block14: {
            if (t1.equals("running")) {
                return LineType.RUNNING;
            }
            if (t1.equals("thread")) {
                return LineType.OUTPUT_HEADER;
            }
            if (t1.equals("latency")) {
                if (t2.equals("distribution")) {
                    return LineType.LATENCY_DIST_BUCKET_HEADER;
                }
                return LineType.LATENCY_DIST;
            }
            if (t1.equals("req/sec")) {
                return LineType.REQ_SEC_DIST;
            }
            if (t1.equals("requests/sec:")) {
                return LineType.REQ_SEC;
            }
            if (t1.equals("transfer/sec:")) {
                return LineType.TRANSFER_SEC;
            }
            if (t1.equals("non-2xx")) {
                return LineType.ERROR_COUNT;
            }
            Long.parseLong(t1);
            if (t2.equals("threads")) {
                return LineType.THREAD_CONN_COUNT;
            }
            if (!t2.equals("requests")) break block14;
            return LineType.SUMMARY;
            {
                catch (NumberFormatException e) {
                    return LineType.UNKNOWN;
                }
            }
        }
        try {
            Float.parseFloat(t2);
            return LineType.LATENCY_DIST_BUCKET;
        }
        catch (NumberFormatException e) {
            return LineType.UNKNOWN;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType;

        static {
            $SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType = new int[LineType.values().length];
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.LATENCY_DIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.REQ_SEC_DIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.SUMMARY.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.ERROR_COUNT.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.REQ_SEC.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.TRANSFER_SEC.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.THREAD_CONN_COUNT.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.OUTPUT_HEADER.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.LATENCY_DIST_BUCKET_HEADER.ordinal()] = 10;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.LATENCY_DIST_BUCKET.ordinal()] = 11;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$performance$WrkSummarizerParser$LineType[LineType.UNKNOWN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "wrk";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeUnit {
        MILLISECOND(1),
        SECOND(1000),
        MINUTE(60000),
        HOUR(3600000);

        private final int factor;

        private TimeUnit(int factor) {
            this.factor = factor;
        }

        public int getFactor() {
            return this.factor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LineType {
        RUNNING,
        THREAD_CONN_COUNT,
        OUTPUT_HEADER,
        LATENCY_DIST,
        LATENCY_DIST_BUCKET_HEADER,
        LATENCY_DIST_BUCKET,
        REQ_SEC_DIST,
        SUMMARY,
        REQ_SEC,
        TRANSFER_SEC,
        ERROR_COUNT,
        UNKNOWN;

    }
}

