/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.UriReport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThroughputUriReport {
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private final UriReport uriReport;

    public ThroughputUriReport(UriReport uriReport) {
        this.uriReport = uriReport;
    }

    public long get() {
        List<HttpSample> httpSamples = this.uriReport.getHttpSampleList();
        long durationInSeconds = this.calculateTestingDuration(httpSamples);
        return (long)httpSamples.size() / durationInSeconds;
    }

    private long calculateTestingDuration(List<HttpSample> httpSamples) {
        long testingStartTime = this.testingStartTime(httpSamples);
        long testingFinishTime = this.testingFinishTime(httpSamples);
        long testingDuration = (testingFinishTime - testingStartTime) / 1000L;
        return Math.max(testingDuration, 1L);
    }

    private long testingStartTime(List<HttpSample> httpSamples) {
        long min = -1L;
        for (HttpSample httpSample : httpSamples) {
            if (min >= 0L && min <= httpSample.getDate().getTime()) continue;
            min = httpSample.getDate().getTime();
        }
        return min;
    }

    private long testingFinishTime(List<HttpSample> httpSamples) {
        long max = 0L;
        for (HttpSample httpSample : httpSamples) {
            if (max >= httpSample.getDate().getTime() + httpSample.getDuration()) continue;
            max = httpSample.getDate().getTime() + httpSample.getDuration();
        }
        return max;
    }
}

