/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceBuildAction
implements Action,
StaplerProxy {
    private final AbstractBuild<?, ?> build;
    private final List<PerformanceReportParser> parsers;
    private final transient PrintStream hudsonConsoleWriter;
    private transient WeakReference<PerformanceReportMap> performanceReportMap;
    private static final Logger logger = Logger.getLogger(PerformanceBuildAction.class.getName());

    public PerformanceBuildAction(AbstractBuild<?, ?> pBuild, PrintStream logger, List<PerformanceReportParser> parsers) {
        this.build = pBuild;
        this.hudsonConsoleWriter = logger;
        this.parsers = parsers;
    }

    public PerformanceReportParser getParserByDisplayName(String displayName) {
        if (this.parsers != null) {
            for (PerformanceReportParser parser : this.parsers) {
                if (!parser.getDescriptor().getDisplayName().equals(displayName)) continue;
                return parser;
            }
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.BuildAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "performance";
    }

    public PerformanceReportMap getTarget() {
        return this.getPerformanceReportMap();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    PrintStream getHudsonConsoleWriter() {
        return this.hudsonConsoleWriter;
    }

    public PerformanceReportMap getPerformanceReportMap() {
        PerformanceReportMap reportMap = null;
        WeakReference<PerformanceReportMap> wr = this.performanceReportMap;
        if (wr != null && (reportMap = (PerformanceReportMap)wr.get()) != null) {
            return reportMap;
        }
        try {
            reportMap = new PerformanceReportMap(this, (TaskListener)StreamTaskListener.fromStderr());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error creating new PerformanceReportMap()", e);
        }
        this.performanceReportMap = new WeakReference<PerformanceReportMap>(reportMap);
        return reportMap;
    }

    public void setPerformanceReportMap(WeakReference<PerformanceReportMap> performanceReportMap) {
        this.performanceReportMap = performanceReportMap;
    }
}

