/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.pegdown_formatter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IsolatingClassLoader
extends SecureClassLoader {
    private final Map<String, byte[]> classes = new HashMap<String, byte[]>();

    public IsolatingClassLoader(InputStream bundle) throws IOException {
        ZipEntry library;
        ZipInputStream bundleZIS = new ZipInputStream(bundle);
        while ((library = bundleZIS.getNextEntry()) != null) {
            ZipEntry classDef;
            if (library.isDirectory()) continue;
            byte[] jar = this.readEntry(bundleZIS);
            ZipInputStream libraryZIS = new ZipInputStream(new ByteArrayInputStream(jar));
            while ((classDef = libraryZIS.getNextEntry()) != null) {
                if (classDef.isDirectory()) continue;
                this.classes.put(classDef.getName(), this.readEntry(libraryZIS));
            }
        }
    }

    private byte[] readEntry(ZipInputStream zipInputStream) throws IOException {
        int cnt;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((cnt = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, cnt);
        }
        return baos.toByteArray();
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            int index;
            if (securityManager != null && (index = name.lastIndexOf(46)) > 0) {
                securityManager.checkPackageAccess(name.substring(0, index));
            }
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                clazz = this.findSystemClass(name);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        int index;
        String mapKey = name.replace('.', '/');
        byte[] classBytes = this.classes.get(mapKey + ".class");
        if (classBytes == null) {
            throw new ClassNotFoundException(name);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (index = name.lastIndexOf(46)) > 0) {
            securityManager.checkPackageDefinition(name.substring(0, index));
        }
        return super.defineClass(name, classBytes, 0, classBytes.length, (CodeSource)null);
    }

    public InputStream getResourceAsStream(String id) {
        if (id == null) {
            return null;
        }
        String mapKey = id.charAt(0) == '/' ? id.substring(1) : id;
        byte[] resource = this.classes.get(mapKey);
        if (resource == null) {
            return null;
        }
        return new ByteArrayInputStream(resource);
    }
}

