/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.pegdown_formatter;

import java.util.ArrayList;
import java.util.List;
import org.jenkins_ci.plugins.pegdown_formatter.PegDownExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtils {
    public static final List<PegDownExtension> DEFAULTS = new ArrayList<PegDownExtension>();
    public static final List<PegDownExtension> ADVANCED_DEFAULTS;

    public static int toFlags(List<PegDownExtension> extensions, List<PegDownExtension> advancedExtensions) {
        int flags = ExtensionUtils.combineFlags(0, extensions);
        return ExtensionUtils.combineFlags(flags, advancedExtensions);
    }

    public static int combineFlags(int currentFlags, List<PegDownExtension> extensions) {
        int flags = currentFlags;
        for (PegDownExtension extension : extensions) {
            if (!extension.isSelected()) continue;
            flags |= extension.getFlag();
        }
        return flags;
    }

    static {
        DEFAULTS.add(new PegDownExtension("SUPPRESS_ALL_HTML", 196608, false));
        ADVANCED_DEFAULTS = new ArrayList<PegDownExtension>();
        ADVANCED_DEFAULTS.add(new PegDownExtension("ABBREVIATIONS", 4, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("AUTOLINKS", 16, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("DEFINITIONS", 64, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("FENCED_CODE_BLOCKS", 128, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("HARDWRAPS", 8, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("NO_FOLLOW_LINKS", 262144, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("SMARTYPANTS", 3, true));
        ADVANCED_DEFAULTS.add(new PegDownExtension("TABLES", 32, true));
    }
}

