/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependencyGraph;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.CapturedEnvironmentAction;
import hudson.plugins.parameterizedtrigger.DynamicBuildAction;
import hudson.plugins.parameterizedtrigger.DynamicProjectAction;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildTrigger
extends Notifier
implements DependencyDeclarer {
    private final ArrayList<BuildTriggerConfig> configs;

    @DataBoundConstructor
    public BuildTrigger(List<BuildTriggerConfig> configs) {
        this.configs = new ArrayList(Util.fixNull(configs));
    }

    public BuildTrigger(BuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singletonList(new DynamicProjectAction(this.configs));
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        HashMap<String, AbstractBuild> downstreamMap = new HashMap<String, AbstractBuild>();
        HashMap<String, Integer> buildMap = new HashMap<String, Integer>();
        boolean hasEnvVariables = false;
        HashSet<BuildTriggerConfig> alreadyFired = new HashSet<BuildTriggerConfig>();
        for (BuildTriggerConfig config : this.configs) {
            boolean hasNonAbstractProject = false;
            hasEnvVariables = hasEnvVariables || this.hasEnvVariables(config, build.getEnvironment((TaskListener)listener));
            List<Job> jobs = config.getJobs(build.getRootBuild().getProject().getParent(), build.getEnvironment((TaskListener)listener));
            Iterator<Job> iterator = jobs.iterator();
            while (iterator.hasNext()) {
                Job j = iterator.next();
                if (j instanceof AbstractProject) continue;
                hasNonAbstractProject = true;
                break;
            }
            if (!hasNonAbstractProject) continue;
            config.perform(build, launcher, listener);
            alreadyFired.add(config);
        }
        if (this.canDeclare(build.getProject()) && !hasEnvVariables) {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            build.addAction((Action)new CapturedEnvironmentAction(env));
        } else {
            for (BuildTriggerConfig config : this.configs) {
                if (!alreadyFired.contains(config)) {
                    List<QueueTaskFuture<AbstractBuild>> futures = config.perform(build, launcher, listener);
                    for (QueueTaskFuture queueTaskFuture : futures) {
                        AbstractBuild abstractBuild = null;
                        try {
                            abstractBuild = (AbstractBuild)queueTaskFuture.get();
                            if (null == abstractBuild) continue;
                            downstreamMap.put(abstractBuild.getProject().getFullName(), abstractBuild);
                        }
                        catch (ExecutionException e) {
                            listener.getLogger().println("Failed to execute downstream build");
                        }
                    }
                    String[] projects = config.getProjects(build.getEnvironment((TaskListener)listener)).split(",");
                    String[] stringArray = config.getProjects().split(",");
                    for (int i = 0; i < projects.length; ++i) {
                        AbstractBuild abstractBuild;
                        if (!stringArray[i].trim().contains("$") || null == (abstractBuild = (AbstractBuild)downstreamMap.get(projects[i]))) continue;
                        listener.getLogger().println(this.makeLogEntry(projects[i].trim()));
                        buildMap.put(abstractBuild.getProject().getFullName(), abstractBuild.getNumber());
                    }
                }
                DynamicBuildAction action = new DynamicBuildAction(buildMap);
                build.addAction((Action)action);
            }
        }
        return true;
    }

    private String makeLogEntry(String name) {
        String url = name;
        url = Jenkins.get().getRootUrl() + "job/" + url.replaceAll("/", "/job/");
        name = name.replaceAll("/", " \u00bb ");
        String link = ModelHyperlinkNote.encodeTo((String)url, (String)name);
        StringBuilder sb = new StringBuilder();
        sb.append("Triggering a new build of ");
        sb.append(link);
        return sb.toString();
    }

    private boolean hasEnvVariables(BuildTriggerConfig config, EnvVars env) {
        return !config.getProjects().equalsIgnoreCase(config.getProjects(env));
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!this.canDeclare(owner)) {
            return;
        }
        for (BuildTriggerConfig config : this.configs) {
            List<AbstractProject> projectList = config.getProjectList(owner.getParent(), null);
            for (AbstractProject project : projectList) {
                if (config.isTriggerFromChildProjects() && owner instanceof ItemGroup) {
                    ItemGroup parent = (ItemGroup)owner;
                    for (Item item : parent.getItems()) {
                        if (!(item instanceof AbstractProject)) continue;
                        AbstractProject child = (AbstractProject)item;
                        ParameterizedDependency.add(child, project, config, graph);
                    }
                    continue;
                }
                ParameterizedDependency.add(owner, project, config, graph);
            }
        }
    }

    private boolean canDeclare(AbstractProject owner) {
        return !owner.getClass().getName().equals("hudson.plugins.promoted_builds.PromotionProcess");
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Trigger parameterized build on other projects";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

