/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.FilePath;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Properties;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;

public class ParameterizedTriggerUtils {
    public static Properties loadProperties(String properties) throws IOException {
        Properties p = new Properties();
        p.load(new StringReader(properties));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(FilePath f, String encoding) throws IOException, InterruptedException {
        try (InputStream in = f.read();){
            String string = IOUtils.toString((InputStream)in, (String)encoding);
            return string;
        }
    }

    public static String readFileToString(VirtualFile f) throws IOException, InterruptedException {
        try (InputStream in = f.open();){
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
    }

    public static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }
}

