/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedDependency
extends DependencyGraph.Dependency {
    private BuildTriggerConfig config;

    public ParameterizedDependency(AbstractProject upstream, AbstractProject downstream, BuildTriggerConfig config) {
        super(upstream, downstream);
        this.config = config;
    }

    public static void add(AbstractProject upstream, AbstractProject downstream, BuildTriggerConfig config, DependencyGraph graph) {
        graph.addDependency((DependencyGraph.Dependency)new ParameterizedDependency(upstream, downstream, config));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ParameterizedDependency that = (ParameterizedDependency)((Object)obj);
        return this.getUpstreamProject() == that.getUpstreamProject() || this.getDownstreamProject() == that.getDownstreamProject() || this.config == that.config;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + this.getUpstreamProject().hashCode();
        hash = 23 * hash + this.getDownstreamProject().hashCode();
        hash = 23 * hash + this.config.hashCode();
        return hash;
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        if (!this.config.getCondition().isMet(build.getResult())) {
            return false;
        }
        try {
            List<Action> actionList = this.config.getBaseActions(build, listener);
            if (!actionList.isEmpty()) {
                actions.addAll(this.config.getBuildActions(actionList, this.getDownstreamProject()));
                return true;
            }
            if (this.config.getTriggerWithNoParameters()) {
                return true;
            }
            listener.getLogger().println("[parameterized-trigger] Downstream builds will not be triggered as no parameter is set.");
            return false;
        }
        catch (AbstractBuildParameters.DontTriggerException ex) {
            return false;
        }
        catch (Exception ex) {
            listener.error("Failed to build parameters to trigger project: " + this.getDownstreamProject().getName());
            ex.printStackTrace(listener.getLogger());
            return false;
        }
    }
}

