/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.os.PosixAPI;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.pam.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.IdStrategy;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.Passwd;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.jvnet.libpam.impl.CLibrary;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class PAMSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String serviceName;
    private static final Logger LOGGER = Logger.getLogger(PAMSecurityRealm.class.getName());

    @DataBoundConstructor
    public PAMSecurityRealm(String serviceName) {
        serviceName = Util.fixEmptyAndTrim((String)serviceName);
        if (serviceName == null) {
            serviceName = "sshd";
        }
        this.serviceName = serviceName;
    }

    protected synchronized UserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            UnixUser uu = new PAM(this.serviceName).authenticate(username, password);
            return new User(username, "", true, true, true, true, PAMSecurityRealm.toAuthorities(uu));
        }
        catch (PAMException e) {
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (!UnixUser.exists((String)username)) {
            throw new UsernameNotFoundException("No such Unix user: " + username);
        }
        try {
            UnixUser uu = new UnixUser(username);
            return new User(username, "", true, true, true, true, PAMSecurityRealm.toAuthorities(uu));
        }
        catch (PAMException e) {
            throw new UsernameNotFoundException("Failed to load information about Unix user " + username, (Throwable)e);
        }
    }

    private static GrantedAuthority[] toAuthorities(UnixUser u) {
        Set grps = u.getGroups();
        GrantedAuthority[] groups = new GrantedAuthority[grps.size() + 1];
        int i = 0;
        for (String g : grps) {
            groups[i++] = new GrantedAuthorityImpl(g);
        }
        groups[i++] = AUTHENTICATED_AUTHORITY;
        return groups;
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        final String group2 = groupname.startsWith("@") ? groupname.substring(1) : groupname;
        if (CLibrary.libc.getgrnam(group2) == null) {
            throw new UsernameNotFoundException(group2);
        }
        return new GroupDetails(){

            public String getName() {
                return group2;
            }
        };
    }

    public IdStrategy getUserIdStrategy() {
        return DescriptorImpl.STRATEGY;
    }

    public IdStrategy getGroupIdStrategy() {
        return DescriptorImpl.STRATEGY;
    }

    @Extension
    public static DescriptorImpl install() {
        if (!Functions.isWindows()) {
            return new DescriptorImpl();
        }
        return null;
    }

    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private static final IdStrategy STRATEGY = Util.fixNull((String)System.getProperty("os.name")).contains("OS X") ? IdStrategy.CASE_INSENSITIVE : new IdStrategy.CaseSensitive();

        public String getDisplayName() {
            return Messages.PAMSecurityRealm_DisplayName();
        }

        public FormValidation doTest() {
            File s = new File("/etc/shadow");
            if (s.exists() && !s.canRead()) {
                LOGGER.fine("/etc/shadow exists but not readable");
                POSIX api = PosixAPI.get();
                FileStat st = api.stat("/etc/shadow");
                if (st == null) {
                    return FormValidation.error((String)Messages.PAMSecurityRealm_ReadPermission());
                }
                Passwd pwd = api.getpwuid(api.geteuid());
                String user = pwd != null ? Messages.PAMSecurityRealm_User(pwd.getLoginName()) : Messages.PAMSecurityRealm_CurrentUser();
                Group g = api.getgrgid(st.gid());
                String group2 = g != null ? g.getName() : String.valueOf(st.gid());
                if ((st.mode() & 0x20) != 0) {
                    return FormValidation.error((String)Messages.PAMSecurityRealm_BelongToGroup(user, group2));
                }
                Passwd opwd = api.getpwuid(st.uid());
                String owner = opwd != null ? opwd.getLoginName() : Messages.PAMSecurityRealm_Uid(st.uid());
                return FormValidation.error((String)Messages.PAMSecurityRealm_RunAsUserOrBelongToGroupAndChmod(owner, user, group2));
            }
            return FormValidation.ok((String)Messages.PAMSecurityRealm_Success());
        }
    }
}

